/*
 * Decompiled with CFR 0.152.
 */
package com.skydude.dacxirons.spells;

import com.skydude.dacxirons.entity.mobs.SummonedKamath;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.eldritch.AbstractEldritchSpell;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class SummonKamath
extends AbstractEldritchSpell {
    private final ResourceLocation spellId = new ResourceLocation("dacxirons", "summonkamath");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.ELDRITCH_RESOURCE).setMaxLevel(8).setCooldownSeconds(600.0).build();
    double value = 123.4567;
    double roundedToTwoDecimals = (double)Math.round(this.value * 100.0) / 100.0;

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.summon_count", (Object[])new Object[]{"1"}), Component.m_237110_((String)"ui.dacxirons.summon_hp", (Object[])new Object[]{Math.round(this.getKamathHealth(spellLevel, caster))}), Component.m_237110_((String)"ui.dacxirons.kamath.summon_duration", (Object[])new Object[]{Math.round(this.getKamathDuration(spellLevel, caster) / 20.0f)}));
    }

    public SummonKamath() {
        this.manaCostPerLevel = 25;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 1;
        this.castTime = 200;
        this.baseManaCost = 600;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.RAISE_DEAD_START.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.RAISE_DEAD_FINISH.get());
    }

    private float getKamathDuration(int spellLevel, LivingEntity caster) {
        return (int)(2.0f * this.getSpellPower(spellLevel, (Entity)caster) * 20.0f);
    }

    private float getKamathDamage(int spellLevel, LivingEntity caster) {
        return 15.0f * (float)caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get());
    }

    private float getKamathHealth(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 4.5f;
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int summonTime = (int)this.getKamathDuration(spellLevel, entity);
        float radius = 1.5f + 0.185f * (float)spellLevel;
        SummonedKamath kamath = new SummonedKamath(entity, false);
        double maxHealth = this.getKamathHealth(spellLevel, entity);
        kamath.m_21051_(Attributes.f_22276_).m_22100_(maxHealth);
        kamath.m_21153_((float)maxHealth);
        double damage = this.getKamathDamage(spellLevel, entity);
        kamath.m_21051_(Attributes.f_22281_).m_22100_(damage);
        kamath.m_6518_((ServerLevelAccessor)((ServerLevel)world), world.m_6436_(kamath.m_20097_()), MobSpawnType.MOB_SUMMONED, null, null);
        kamath.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.RAISE_DEAD_TIMER.get(), summonTime, 0, false, false, false));
        float yrot = 6.281f / (float)spellLevel + entity.m_146908_() * ((float)Math.PI / 180);
        Vec3 spawn = Utils.moveToRelativeGroundLevel((Level)world, (Vec3)entity.m_146892_().m_82549_(new Vec3((double)(radius * Mth.m_14089_((float)yrot)), 0.0, (double)(radius * Mth.m_14031_((float)yrot)))), (int)10);
        kamath.m_6034_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_);
        kamath.m_146922_(entity.m_146908_());
        kamath.m_146867_();
        world.m_7967_((Entity)kamath);
        int effectAmplifier = spellLevel - 1;
        entity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.RAISE_DEAD_TIMER.get(), summonTime, 0, false, false, true));
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }
}

