/*
 * Decompiled with CFR 0.152.
 */
package com.skydude.dacxirons.spells;

import com.skydude.dacxirons.registries.EffectRegistry;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Random;
import net.mcreator.dungeonsandcombat.init.DungeonsAndCombatModMobEffects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class FairysWishSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("dacxirons", "fairys_wish_spell");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.NATURE_RESOURCE).setMaxLevel(5).setCooldownSeconds(60.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.dacxirons.amplifier", (Object[])new Object[]{(int)this.getMaxEffectAmplifier(spellLevel, caster)}), Component.m_237110_((String)"ui.dacxirons.duration", (Object[])new Object[]{this.getMaxDuration(spellLevel, caster) / 20}));
    }

    public FairysWishSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 10;
        this.baseManaCost = 100;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        Vec3 origin = entity.m_146892_();
        world.m_45976_(LivingEntity.class, AABB.m_165882_((Vec3)entity.m_20191_().m_82399_(), (double)6.0, (double)6.0, (double)6.0)).forEach(livingEntity -> {
            if (Utils.shouldHealEntity((LivingEntity)entity, (LivingEntity)livingEntity)) {
                List<MobEffect> mobeefect = List.of(MobEffects.f_19603_, (MobEffect)EffectRegistry.CAST_SPEED.get(), (MobEffect)EffectRegistry.SPELL_STRENGTH.get(), MobEffects.f_19600_, MobEffects.f_19596_, MobEffects.f_19621_, MobEffects.f_19607_, MobEffects.f_19598_, (MobEffect)DungeonsAndCombatModMobEffects.ACID_FIRE_EDGE.get(), MobEffects.f_19617_);
                Random random = new Random();
                int randomIndex = random.nextInt(mobeefect.size());
                MobEffectInstance s = new MobEffectInstance(mobeefect.get(randomIndex), (int)(Math.random() * (double)this.getMaxDuration(spellLevel, entity)), (int)(Math.random() * (double)this.getMaxEffectAmplifier(spellLevel, entity)), true, true);
                livingEntity.m_7292_(s);
                randomIndex = random.nextInt(mobeefect.size());
                MobEffectInstance s2 = new MobEffectInstance(mobeefect.get(randomIndex), (int)(Math.random() * (double)this.getMaxDuration(spellLevel, entity)), (int)(Math.random() * (double)this.getMaxEffectAmplifier(spellLevel, entity)), true, true);
                livingEntity.m_7292_(s2);
                System.out.println("s" + String.valueOf(s));
                System.out.println("s2" + String.valueOf(s2));
                MagicManager.spawnParticles((Level)world, (ParticleOptions)ParticleHelper.SIPHON, (double)livingEntity.m_20185_(), (double)(livingEntity.m_20186_() + 0.25), (double)livingEntity.m_20189_(), (int)15, (double)((double)livingEntity.m_20205_() * 0.5), (double)((double)livingEntity.m_20205_() * 0.5), (double)((double)livingEntity.m_20205_() * 0.5), (double)0.0, (boolean)false);
            }
        });
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    public float getMaxEffectAmplifier(int spellLevel, LivingEntity caster) {
        return spellLevel;
    }

    public int getMaxDuration(int spellLevel, LivingEntity caster) {
        return (int)(300.0 * (0.5 * (double)this.getSpellPower(spellLevel, (Entity)caster)));
    }
}

