/*
 * Decompiled with CFR 0.152.
 */
package com.skydude.dacxirons.spells.Blood;

import com.skydude.dacxirons.registries.EffectRegistry;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.mcreator.dungeonsandcombat.init.DungeonsAndCombatModMobEffects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class CrimsonOath
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("dacxirons", "crimson_oath");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(SchoolRegistry.BLOOD_RESOURCE).setMaxLevel(5).setCooldownSeconds(60.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.dacxirons.healthreduction", (Object[])new Object[]{Math.round((double)this.getHealthReduction(spellLevel, caster) * 100.0)}), Component.m_237110_((String)"ui.dacxirons.bloodpower", (Object[])new Object[]{this.getBloodPower(spellLevel, caster)}), Component.m_237110_((String)"ui.dacxirons.duration2", (Object[])new Object[]{this.getDuration(spellLevel, caster) / 20}));
    }

    public CrimsonOath() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 30;
        this.baseManaCost = 30;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.BLOOD_EXPLOSION.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        entity.m_6469_(world.m_269111_().m_269425_(), entity.m_21223_() * this.getHealthReduction(spellLevel, entity));
        entity.m_7292_(new MobEffectInstance((MobEffect)DungeonsAndCombatModMobEffects.BLEEDING.get(), this.getDuration(spellLevel, entity), 0, true, false, true));
        MagicManager.spawnParticles((Level)world, (ParticleOptions)ParticleHelper.SIPHON, (double)entity.m_20185_(), (double)(entity.m_20186_() + 0.25), (double)entity.m_20189_(), (int)15, (double)((double)entity.m_20205_() * 0.5), (double)((double)entity.m_20205_() * 0.5), (double)((double)entity.m_20205_() * 0.5), (double)0.0, (boolean)false);
        entity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLOOD_SPELL_STRENGTH.get(), this.getDuration(spellLevel, entity), spellLevel, true, false, true));
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    public float getHealthReduction(int spellLevel, LivingEntity caster) {
        return 0.8f - 0.1f * (float)spellLevel;
    }

    public int getDuration(int spellLevel, LivingEntity caster) {
        return (int)(20.0f * (10.0f + 20.0f * this.getSpellPower(spellLevel, (Entity)caster)));
    }

    public int getBloodPower(int spellLevel, LivingEntity caster) {
        return 10 + spellLevel * 10;
    }
}

