/*
 * Decompiled with CFR 0.152.
 */
package com.skydude.dacxirons.spells;

import com.skydude.dacxirons.registries.SoundRegistry;
import com.skydude.dacxirons.registries.dacxironsSpellRegistry;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.damage.DamageSources;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.mcreator.dungeonsandcombat.entity.MagicArrowEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

@AutoSpellConfig
public class ArcaneArrow
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("dacxirons", "arcane_arrow");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.EVOCATION_RESOURCE).setMaxLevel(5).setCooldownSeconds(3.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.dacxirons.sunleia.beam", (Object[])new Object[]{Math.round(5.0f * this.getSpellPower(spellLevel, (Entity)caster))}));
    }

    public ArcaneArrow() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 0;
        this.castTime = 30;
        this.baseManaCost = 30;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.MAGIC_ARROW_SOUND.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        LivingEntity le;
        Entity entity2;
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft", "entity.evoker.cast_spell"));
        if (sound != null) {
            world.m_5594_(null, entity.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
            world.m_5594_(null, entity.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else {
            System.out.println("Failed to find sound: entity.evoker.cast_spell");
        }
        double reach = 48.0;
        Vec3 start = entity.m_146892_();
        Vec3 end = start.m_82549_(entity.m_20154_().m_82490_(reach));
        AABB aabb = entity.m_20191_().m_82369_(entity.m_20154_().m_82490_(reach)).m_82400_(1.0);
        Predicate<Entity> filter = e -> e instanceof LivingEntity && e != entity && e.m_6087_() && !e.m_5833_() && e.m_6084_();
        EntityHitResult hit = ProjectileUtil.m_37287_((Entity)entity, (Vec3)start, (Vec3)end, (AABB)aabb, filter, (double)(reach * reach));
        LivingEntity target = hit != null && (entity2 = hit.m_82443_()) instanceof LivingEntity ? (le = (LivingEntity)entity2) : null;
        MagicArrowEntity.shoot((Level)world, (LivingEntity)entity, (RandomSource)RandomSource.m_216327_(), (float)1.0f, (double)this.getDamage(spellLevel, entity), (int)1);
        if (target != null) {
            DamageSources.applyDamage((Entity)target, (float)0.0f, (DamageSource)((AbstractSpell)dacxironsSpellRegistry.ARCANE_ARROW.get()).getDamageSource((Entity)entity));
        }
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    public float getDamage(int spellLevel, LivingEntity caster) {
        return 5.0f * this.getSpellPower(spellLevel, (Entity)caster);
    }
}

