/*
 * Decompiled with CFR 0.152.
 */
package com.skydude.dacxirons.mixin;

import com.skydude.dacxirons.registries.dacxironsSpellRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import io.redspace.ironsspellbooks.api.spells.IPresetSpellContainer;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import java.util.Arrays;
import java.util.List;
import net.mcreator.dungeonsandcombat.item.OathSwordItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={OathSwordItem.class}, remap=true)
public abstract class OathSwordItemMixin
implements IPresetSpellContainer {
    @Unique
    private static final Logger LOG = LoggerFactory.getLogger((String)"dacxirons");
    @Unique
    private static final SpellDataRegistryHolder[] DEFAULT_SPELLS = new SpellDataRegistryHolder[]{new SpellDataRegistryHolder(dacxironsSpellRegistry.ELDRITCH_SLASH_SPELL, 1)};
    @Unique
    private List<SpellData> dacxirons$spellData;

    @Unique
    private List<SpellData> dacxirons$getSpells() {
        if (this.dacxirons$spellData == null) {
            this.dacxirons$spellData = Arrays.stream(DEFAULT_SPELLS).map(SpellDataRegistryHolder::getSpellData).toList();
        }
        return this.dacxirons$spellData;
    }

    @Inject(method={"appendHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V"}, at={@At(value="HEAD")})
    private void dacxirons$onHover(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag, CallbackInfo ci) {
        if (!ISpellContainer.isSpellContainer((ItemStack)stack)) {
            this.initializeSpellContainer(stack);
            LOG.info("[dacxirons] Initialized spell container (on hover) for {}", (Object)stack.m_41786_().getString());
        }
    }

    public void initializeSpellContainer(ItemStack itemStack) {
        if (itemStack == null || ISpellContainer.isSpellContainer((ItemStack)itemStack)) {
            return;
        }
        List<SpellData> spells = this.dacxirons$getSpells();
        ISpellContainer container = ISpellContainer.create((int)spells.size(), (boolean)true, (boolean)false);
        spells.forEach(sd -> container.addSpell(sd.getSpell(), sd.getLevel(), true, null));
        container.save(itemStack);
    }
}

