/*
 * Decompiled with CFR 0.152.
 */
package com.skydude.dacxirons.item.armor;

import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public enum dacxironsArmorMaterials implements ArmorMaterial
{
    CRIMSON_SPELL_ARMOR("crimson_spell_armor", 60, new int[]{5, 8, 10, 6}, 20, SoundEvents.f_11679_, 2.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dacxirons", "crimson_cloth"))}), Map.of((Attribute)AttributeRegistry.MAX_MANA.get(), new AttributeModifier("Max mana", 125.0, AttributeModifier.Operation.ADDITION), (Attribute)AttributeRegistry.BLOOD_SPELL_POWER.get(), new AttributeModifier("Blood Spell power", 0.15, AttributeModifier.Operation.MULTIPLY_BASE))),
    EBONY_SPELL_ARMOR("ebony_spell_armor", 60, new int[]{3, 6, 8, 3}, 20, SoundEvents.f_11679_, 2.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_and_combat", "ebony_ingot"))}), Map.of((Attribute)AttributeRegistry.MAX_MANA.get(), new AttributeModifier("Max mana", 100.0, AttributeModifier.Operation.ADDITION), (Attribute)AttributeRegistry.COOLDOWN_REDUCTION.get(), new AttributeModifier("coldown", 0.05, AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.SPELL_POWER.get(), new AttributeModifier("cossldown", 0.1, AttributeModifier.Operation.MULTIPLY_BASE))),
    BLESSED_PRIEST_ARMOR("blessed_priest_armor", 60, new int[]{3, 6, 8, 3}, 20, SoundEvents.f_11679_, 2.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_and_combat", "blessed_gold_ingot"))}), Map.of((Attribute)AttributeRegistry.MAX_MANA.get(), new AttributeModifier("Max mana", 125.0, AttributeModifier.Operation.ADDITION), (Attribute)AttributeRegistry.HOLY_SPELL_POWER.get(), new AttributeModifier("holy moly", 0.2, AttributeModifier.Operation.MULTIPLY_BASE))),
    BLAZYMANCER_ARMOR("blazymancer_spell_armor", 60, new int[]{0, 0, 5, 2}, 20, SoundEvents.f_11678_, 2.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_and_combat", "blazing_ingot"))}), Map.of((Attribute)AttributeRegistry.MAX_MANA.get(), new AttributeModifier("Max mana", 100.0, AttributeModifier.Operation.ADDITION), (Attribute)AttributeRegistry.FIRE_SPELL_POWER.get(), new AttributeModifier("Fire Spell power", 0.1, AttributeModifier.Operation.MULTIPLY_BASE), (Attribute)AttributeRegistry.FIRE_MAGIC_RESIST.get(), new AttributeModifier("Fire Spell resist", 0.15, AttributeModifier.Operation.MULTIPLY_BASE)));

    private static final int[] HEALTH_PER_SLOT;
    private final String name;
    private final int durabilityMultiplier;
    private final int[] slotProtections;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairIngredient;
    private final Map<Attribute, AttributeModifier> additionalAttributes;

    private dacxironsArmorMaterials(String pName, int pDurabilityMultiplier, int[] pSlotProtections, int pEnchantmentValue, SoundEvent pSound, float pToughness, float pKnockbackResistance, Supplier<Ingredient> pRepairIngredient, Map<Attribute, AttributeModifier> additionalAttributes) {
        this.name = pName;
        this.durabilityMultiplier = pDurabilityMultiplier;
        this.slotProtections = pSlotProtections;
        this.enchantmentValue = pEnchantmentValue;
        this.sound = pSound;
        this.toughness = pToughness;
        this.knockbackResistance = pKnockbackResistance;
        this.repairIngredient = pRepairIngredient;
        this.additionalAttributes = additionalAttributes;
    }

    public int m_266425_(ArmorItem.Type type) {
        return HEALTH_PER_SLOT[type.m_266308_().m_20749_()] * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.slotProtections[type.m_266308_().m_20749_()];
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    @NotNull
    public SoundEvent m_7344_() {
        return this.sound;
    }

    @NotNull
    public Ingredient m_6230_() {
        return this.repairIngredient.get();
    }

    @NotNull
    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public Map<Attribute, AttributeModifier> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
    }
}

