/*
 * Decompiled with CFR 0.152.
 */
package com.skydude.dacxirons.item.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.skydude.dacxirons.item.armor.dacxironsArmorMaterials;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class dacxironsArmorItem
extends ArmorItem {
    private static final UUID[] ARMOR_ATTRIBUTE_UUID_PER_SLOT = new UUID[]{UUID.fromString("F7BFFA65-547A-49D2-8804-3D533070E432"), UUID.fromString("B05AF2C0-5862-4CE6-860A-522C11E1571A"), UUID.fromString("15C1FE6B-3596-412A-B6CF-4077CB37140F"), UUID.fromString("82A575D1-366A-4BBD-91F8-25DB6B804F06")};
    private final Multimap<Attribute, AttributeModifier> ARMOR_ATTRIBUTES;

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == this.f_265916_.m_266308_()) {
            return this.ARMOR_ATTRIBUTES;
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public dacxironsArmorItem(dacxironsArmorMaterials materialIn, ArmorItem.Type type, Item.Properties settings) {
        super((ArmorMaterial)materialIn, type, settings);
        EquipmentSlot slot = type.m_266308_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        float defense = materialIn.m_7366_(type);
        float toughness = materialIn.m_6651_();
        float knockbackResistance = materialIn.m_6649_();
        UUID uuid = ARMOR_ATTRIBUTE_UUID_PER_SLOT[slot.m_20749_()];
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)defense, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)toughness, AttributeModifier.Operation.ADDITION));
        if (knockbackResistance > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)knockbackResistance, AttributeModifier.Operation.ADDITION));
        }
        for (Map.Entry<Attribute, AttributeModifier> modifierEntry : materialIn.getAdditionalAttributes().entrySet()) {
            AttributeModifier atr = modifierEntry.getValue();
            atr = new AttributeModifier(uuid, atr.m_22214_(), atr.m_22218_(), atr.m_22217_());
            builder.put((Object)modifierEntry.getKey(), (Object)atr);
        }
        this.ARMOR_ATTRIBUTES = builder.build();
    }
}

