/*
 * Decompiled with CFR 0.152.
 */
package com.skydude.dacxirons.entity.spells.AcidBall;

import com.skydude.dacxirons.registries.EntityRegistry;
import com.skydude.dacxirons.registries.dacxironsSpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.mcreator.dungeonsandcombat.procedures.AcidFireBallProjectileHitsBlockProcedure;
import net.mcreator.dungeonsandcombat.procedures.AcidFireBallProjectileHitsLivingEntityProcedure;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AcidFireball
extends AbstractMagicProjectile {
    private final Level worldRef;

    public AcidFireball(EntityType<? extends Projectile> pEntityType, Level level) {
        super(pEntityType, level);
        this.worldRef = level;
        this.m_20242_(true);
    }

    public AcidFireball(LivingEntity pShooter, Level level) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.ACID_BALL.get()), level);
        this.m_5602_((Entity)pShooter);
    }

    public void trailParticles() {
        Vec3 vec3 = this.m_20184_();
        double d0 = this.m_20185_() - vec3.f_82479_;
        double d1 = this.m_20186_() - vec3.f_82480_;
        double d2 = this.m_20189_() - vec3.f_82481_;
        int count = Mth.m_14045_((int)((int)(vec3.m_82556_() * 4.0)), (int)1, (int)4);
        for (int i = 0; i < count; ++i) {
            Vec3 random = Utils.getRandomVec3((double)0.25);
            float f = (float)i / (float)count;
            double x = Mth.m_14139_((double)f, (double)d0, (double)this.m_20185_());
            double y = Mth.m_14139_((double)f, (double)d1, (double)this.m_20186_());
            double z = Mth.m_14139_((double)f, (double)d2, (double)this.m_20189_());
            this.worldRef.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x - random.f_82479_, y + 0.5 - random.f_82480_, z - random.f_82481_, random.f_82479_ * 0.5, random.f_82480_ * 0.5, random.f_82481_ * 0.5);
            this.worldRef.m_7106_(ParticleHelper.POISON_CLOUD, x - random.f_82479_, y + 0.5 - random.f_82480_, z - random.f_82481_, random.f_82479_ * 0.5, random.f_82480_ * 0.5, random.f_82481_ * 0.5);
        }
    }

    public void impactParticles(double x, double y, double z) {
    }

    public float getSpeed() {
        return 1.15f;
    }

    public Optional<SoundEvent> getImpactSound() {
        return Optional.of(SoundEvents.f_11913_);
    }

    protected void m_6532_(HitResult hitResult) {
        if (!this.worldRef.f_46443_) {
            this.impactParticles(this.f_19790_, this.f_19791_, this.f_19792_);
            float explosionRadius = this.getExplosionRadius();
            float explosionRadiusSqr = explosionRadius * explosionRadius;
            List entities = this.worldRef.m_45933_((Entity)this, this.m_20191_().m_82400_((double)explosionRadius));
            Vec3 losPoint = Utils.raycastForBlock((Level)this.worldRef, (Vec3)this.m_20182_(), (Vec3)this.m_20182_().m_82520_(0.0, 2.0, 0.0), (ClipContext.Fluid)ClipContext.Fluid.NONE).m_82450_();
            for (Entity entity : entities) {
                double distanceSqr = entity.m_20238_(hitResult.m_82450_());
                if (!(distanceSqr < (double)explosionRadiusSqr) || !this.m_5603_(entity) || !Utils.hasLineOfSight((Level)this.worldRef, (Vec3)losPoint, (Vec3)entity.m_20191_().m_82399_(), (boolean)true)) continue;
                double p = 1.0 - distanceSqr / (double)explosionRadiusSqr;
                float damage = (float)((double)this.damage * p);
                DamageSources.applyDamage((Entity)entity, (float)damage, (DamageSource)((AbstractSpell)dacxironsSpellRegistry.ACID_BALL_SPELL.get()).getDamageSource((Entity)this, this.m_19749_()));
                if (!(entity instanceof LivingEntity)) continue;
                AcidFireBallProjectileHitsLivingEntityProcedure.execute((LevelAccessor)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (Entity)entity);
            }
            this.m_5496_(SoundEvents.f_11913_, 4.0f, (1.0f + (this.worldRef.f_46441_.m_188501_() - this.worldRef.f_46441_.m_188501_()) * 0.2f) * 0.7f);
            this.m_146870_();
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof AcidFireball)) {
            return;
        }
        AcidFireball proj = (AcidFireball)entity;
        HitResult hitResult = event.getRayTraceResult();
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult hit = (BlockHitResult)hitResult;
        Level level = proj.m_9236_();
        System.out.println("[AcidFireball] ProjectileImpactEvent fired side=" + (level.f_46443_ ? "CLIENT" : "SERVER") + " pos=" + String.valueOf(hit.m_82425_()));
        if (!level.f_46443_) {
            Vec3 loc = hit.m_82450_();
            AcidFireBallProjectileHitsBlockProcedure.execute((LevelAccessor)level, (double)loc.f_82479_, (double)loc.f_82480_, (double)loc.f_82481_);
        }
    }
}

