/*
 * Decompiled with CFR 0.152.
 */
package com.skydude.dacxirons;

import com.skydude.dacxirons.dacxironsConfig;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dacxirons")
public class OverrideRogueLogic {
    private static final WeakHashMap<ServerPlayer, Integer> lastHitTickMap = new WeakHashMap();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (dacxironsConfig.ENABLE_CUSTOM_ROGUE_LOGIC.get() != Boolean.TRUE) {
            return;
        }
        if (!player.m_8960_().m_135996_(Objects.requireNonNull(player.f_8924_.m_129889_().m_136041_(new ResourceLocation("dungeons_and_combat:the_rogue")))).m_8193_()) {
            return;
        }
        lastHitTickMap.put(player, player.f_19797_);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!((Boolean)dacxironsConfig.ENABLE_CUSTOM_ROGUE_LOGIC.get()).booleanValue()) {
            return;
        }
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!player2.m_8960_().m_135996_(Objects.requireNonNull(player2.f_8924_.m_129889_().m_136041_(new ResourceLocation("dungeons_and_combat:the_rogue")))).m_8193_()) {
            return;
        }
        ServerPlayer living = player2;
        living.m_21195_(MobEffects.f_19609_);
        int lastHitTick = lastHitTickMap.getOrDefault(player2, -99999);
        int cooldownTicks = (int)((Double)dacxironsConfig.INVIS_REMOVAL_TIME.get() * 20.0);
        if (player2.m_6144_() && !player2.m_9236_().m_5776_() && lastHitTick + cooldownTicks < player2.f_19797_ && !living.m_21023_((MobEffect)MobEffectRegistry.TRUE_INVISIBILITY.get())) {
            living.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.TRUE_INVISIBILITY.get(), ((Integer)dacxironsConfig.INVIS_EFFECT_TIME.get()).intValue(), 100, true, true));
        }
    }
}

