/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.registry.skills;

import com.seniors.justlevelingfork.client.core.Utils;
import com.seniors.justlevelingfork.client.core.Value;
import com.seniors.justlevelingfork.client.core.ValueType;
import com.seniors.justlevelingfork.common.capability.AptitudeCapability;
import com.seniors.justlevelingfork.handler.HandlerConfigClient;
import com.seniors.justlevelingfork.handler.HandlerResources;
import com.seniors.justlevelingfork.registry.RegistryAptitudes;
import com.seniors.justlevelingfork.registry.RegistryCapabilities;
import com.seniors.justlevelingfork.registry.aptitude.Aptitude;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class Skill {
    public final ResourceLocation key;
    public final Aptitude aptitude;
    public final int requiredLevel;
    public final ResourceLocation texture;
    private final Value[] configValues;

    public Skill(ResourceLocation skillKey, Aptitude aptitude, int levelRequirement, ResourceLocation skillTexture, Value ... skillValues) {
        this.key = skillKey;
        this.aptitude = aptitude;
        this.requiredLevel = levelRequirement;
        this.texture = skillTexture;
        this.configValues = skillValues;
    }

    public static Skill add(String skillName, String aptitudeName, int levelRequirement, String texture, Value ... skillValues) {
        Aptitude aptitude = RegistryAptitudes.getAptitude(aptitudeName);
        if (aptitude == null) {
            throw new IllegalArgumentException("Aptitude name doesn't exist: " + aptitudeName);
        }
        ResourceLocation key = new ResourceLocation("justlevelingfork", skillName);
        return new Skill(key, aptitude, levelRequirement, HandlerResources.create(texture), skillValues);
    }

    public Skill get() {
        return this;
    }

    public String getMod() {
        return this.key.m_135827_();
    }

    public String getName() {
        return this.key.m_135815_();
    }

    public String getKey() {
        return "skill." + this.key.m_214298_();
    }

    public String getDescription() {
        return this.getKey() + ".description";
    }

    public int getLvl() {
        return this.requiredLevel;
    }

    public double[] getValue() {
        double[] newValue = new double[this.configValues.length];
        for (int i = 0; i < newValue.length; ++i) {
            newValue[i] = 0.0;
            if (this.configValues[i] == null) continue;
            Object object = this.configValues[i].value;
            if (object instanceof Double) {
                newValue[i] = (Double)object;
            }
            if ((object = this.configValues[i].value) instanceof Integer) {
                newValue[i] = ((Integer)object).intValue();
            }
            if (!((object = this.configValues[i].value) instanceof Number)) continue;
            Number value = (Number)object;
            newValue[i] = value.doubleValue();
        }
        return newValue;
    }

    public MutableComponent getMutableDescription(String description) {
        Object[] newValue = new Object[this.configValues.length];
        for (int i = 0; i < newValue.length; ++i) {
            if (this.configValues[i] == null) continue;
            newValue[i] = this.getParameter(this.configValues[i].type, this.getValue()[i]);
        }
        return Component.m_237110_((String)description, (Object[])newValue);
    }

    public String getParameter(ValueType type, double parameterValue) {
        DecimalFormat df = new DecimalFormat("0.##");
        String probabilityValue = Utils.periodValue(1.0 / parameterValue * 100.0);
        Object parameter = df.format(parameterValue);
        if (type.equals((Object)ValueType.MODIFIER)) {
            parameter = "\u00a7cx" + (String)parameter;
        }
        if (type.equals((Object)ValueType.DURATION)) {
            parameter = "\u00a79" + (String)parameter + "s";
        }
        if (type.equals((Object)ValueType.AMPLIFIER)) {
            parameter = "\u00a76+" + (String)parameter;
        }
        if (type.equals((Object)ValueType.PERCENT)) {
            parameter = "\u00a72" + (String)parameter + "%";
        }
        if (type.equals((Object)ValueType.BOOST)) {
            parameter = "\u00a7d" + Utils.intToRoman(Integer.parseInt((String)parameter));
        }
        if (type.equals((Object)ValueType.PROBABILITY)) {
            parameter = "\u00a7e1/" + (String)parameter + "\u00a7r\u00a77 (\u00a72" + probabilityValue + "%\u00a77\u00a7r)";
        }
        return (String)parameter + "\u00a7r\u00a77";
    }

    public List<Component> tooltip() {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tooltip.skill.title").m_7220_((Component)Component.m_237115_((String)this.getKey())).m_130940_(ChatFormatting.AQUA));
        list.add((Component)Component.m_237115_((String)("tooltip.skill.description." + (this.canSkill() ? "on" : "off"))).m_130940_(this.canSkill() ? ChatFormatting.GREEN : ChatFormatting.RED));
        list.add((Component)Component.m_237119_());
        if (Screen.m_96638_()) {
            list.add((Component)Component.m_237119_().m_7220_((Component)Component.m_237115_((String)this.getKey()).m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.UNDERLINE)).m_7220_((Component)Component.m_237113_((String)": ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)this.getMutableDescription(this.getDescription()).m_130940_(ChatFormatting.GRAY)));
            list.add((Component)Component.m_237119_());
            list.add((Component)Component.m_237115_((String)"tooltip.skill.description.level_requirement").m_130940_(ChatFormatting.DARK_PURPLE));
            if (this.requiredLevel > 0) {
                list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"tooltip.skill.description.available", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.getLvl())).m_130940_(ChatFormatting.GREEN)})).m_130940_(ChatFormatting.DARK_AQUA));
            } else {
                list.add((Component)Component.m_237115_((String)"tooltip.skill.description.off").m_130940_(ChatFormatting.RED));
            }
        } else {
            list.add((Component)Component.m_237115_((String)"tooltip.general.description.more_information").m_130940_(ChatFormatting.YELLOW));
        }
        if (((Boolean)HandlerConfigClient.showSkillModName.get()).booleanValue()) {
            list.add((Component)Component.m_237113_((String)Utils.getModName(this.getMod())).m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC));
        }
        return list;
    }

    public boolean canSkill() {
        return this.requiredLevel > 0 && AptitudeCapability.get().getToggleSkill(this);
    }

    public boolean canSkill(Player player) {
        return this.requiredLevel > 0 && AptitudeCapability.get(player).getToggleSkill(this);
    }

    public boolean getToggle() {
        return this.requiredLevel > 0 && AptitudeCapability.get().getAptitudeLevel(this.aptitude) >= this.requiredLevel;
    }

    public boolean getToggle(Player player) {
        return this.requiredLevel > 0 && AptitudeCapability.get(player).getAptitudeLevel(this.aptitude) >= this.requiredLevel;
    }

    public boolean isEnabled() {
        if (this.requiredLevel < 1) {
            return true;
        }
        if (AptitudeCapability.get() == null) {
            return false;
        }
        return AptitudeCapability.get().getAptitudeLevel(this.aptitude) >= this.requiredLevel && AptitudeCapability.get().getToggleSkill(this);
    }

    public boolean isEnabled(Player player) {
        AtomicBoolean b = new AtomicBoolean(false);
        if (player != null && !player.m_21224_()) {
            player.getCapability(RegistryCapabilities.APTITUDE).ifPresent(aptitudeCapability -> b.set(this.requiredLevel > 0 && AptitudeCapability.get(player).getAptitudeLevel(this.aptitude) >= this.requiredLevel && AptitudeCapability.get(player).getToggleSkill(this)));
        }
        return b.get();
    }

    public ResourceLocation getTexture() {
        return Objects.requireNonNullElse(this.texture, HandlerResources.NULL_SKILL);
    }
}

