/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.registry.aptitude;

import com.seniors.justlevelingfork.common.capability.AptitudeCapability;
import com.seniors.justlevelingfork.handler.HandlerCommonConfig;
import com.seniors.justlevelingfork.registry.RegistryPassives;
import com.seniors.justlevelingfork.registry.RegistrySkills;
import com.seniors.justlevelingfork.registry.passive.Passive;
import com.seniors.justlevelingfork.registry.skills.Skill;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class Aptitude {
    public final int index;
    public final ResourceLocation key;
    public final ResourceLocation[] lockedTexture;
    public final ResourceLocation background;
    public List<Skill> list = new ArrayList<Skill>();

    public Aptitude(int index, ResourceLocation key, ResourceLocation[] lockedTexture, ResourceLocation background) {
        this.index = index;
        this.key = key;
        this.lockedTexture = lockedTexture;
        this.background = background;
    }

    public Aptitude get() {
        return this;
    }

    public String getName() {
        return this.key.m_135815_();
    }

    public String getKey() {
        return "aptitude." + this.key.m_214298_();
    }

    public String getDescription() {
        return this.getKey() + ".description";
    }

    public void setList(List<Skill> list) {
        this.list = list;
    }

    public List<Skill> getSkills(Aptitude aptitude) {
        ArrayList<Skill> list = new ArrayList<Skill>();
        for (int i = 0; i < RegistrySkills.SKILLS_REGISTRY.get().getValues().stream().toList().size(); ++i) {
            Skill skill = (Skill)RegistrySkills.SKILLS_REGISTRY.get().getValues().stream().toList().get(i);
            if (skill.aptitude != aptitude) continue;
            list.add(skill);
        }
        return list;
    }

    public List<Passive> getPassives(Aptitude aptitude) {
        ArrayList<Passive> list = new ArrayList<Passive>();
        for (int i = 0; i < RegistryPassives.PASSIVES_REGISTRY.get().getValues().stream().toList().size(); ++i) {
            Passive passive = (Passive)RegistryPassives.PASSIVES_REGISTRY.get().getValues().stream().toList().get(i);
            if (passive.aptitude != aptitude) continue;
            list.add(passive);
        }
        return list;
    }

    public int getLevel() {
        return AptitudeCapability.get().getAptitudeLevel(this);
    }

    public int getLevel(Player player) {
        return AptitudeCapability.get(player).getAptitudeLevel(this);
    }

    public MutableComponent getRank(int aptitudeLevel) {
        MutableComponent rank = Component.m_237115_((String)"aptitude.justlevelingfork.rank.0");
        for (int i = 0; i < 9; ++i) {
            if (aptitudeLevel < ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).aptitudeMaxLevel / 8 * i) continue;
            rank = Component.m_237115_((String)("aptitude.justlevelingfork.rank." + i));
        }
        return rank;
    }

    public ResourceLocation getLockedTexture(int fromLevel) {
        int textureListSize = this.lockedTexture.length;
        int size = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).aptitudeMaxLevel;
        int index = Math.floorDiv(fromLevel * textureListSize, size);
        int n = index = index == textureListSize ? index - 1 : index;
        if (this.getLevel() > size) {
            AptitudeCapability.get().setAptitudeLevel(this, size);
        }
        if (index >= 4) {
            index = 3;
        }
        return this.lockedTexture[index];
    }

    public ResourceLocation getLockedTexture() {
        int index;
        int size = ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).aptitudeMaxLevel;
        int textureListSize = this.lockedTexture.length;
        if (this.getLevel() > size) {
            AptitudeCapability.get().setAptitudeLevel(this, size);
        }
        int n = index = (index = Math.floorDiv(this.getLevel() * textureListSize, size)) == textureListSize ? index - 1 : index;
        if (index >= 4) {
            index = 3;
        }
        return this.lockedTexture[index];
    }
}

