/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.registry;

import com.seniors.justlevelingfork.client.core.Aptitudes;
import com.seniors.justlevelingfork.common.capability.AptitudeCapability;
import com.seniors.justlevelingfork.handler.HandlerAptitude;
import com.seniors.justlevelingfork.integration.TetraIntegration;
import com.seniors.justlevelingfork.registry.aptitude.Aptitude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class RegistryClientEvents {
    @SubscribeEvent
    public void onTooltipDisplay(ItemTooltipEvent event) {
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_6084_()) {
            List<String> extractedTypes;
            List tooltips = event.getToolTip();
            ItemStack itemStack = event.getItemStack();
            ResourceLocation location = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()));
            if (ModList.get().isLoaded("tetra") && TetraIntegration.TetraItems.contains(location.toString()) && !(extractedTypes = TetraIntegration.GetItemTypes(itemStack)).isEmpty()) {
                ArrayList aptitudesList = new ArrayList();
                for (String tetraItem : extractedTypes) {
                    List<Aptitudes> list = HandlerAptitude.getValue(tetraItem);
                    if (list == null) continue;
                    list.forEach(c -> {
                        if (!aptitudesList.contains(c)) {
                            aptitudesList.add(c);
                        }
                    });
                }
                if (!aptitudesList.isEmpty()) {
                    tooltips.add(Component.m_237119_());
                    tooltips.add(Component.m_237115_((String)"tooltip.aptitude.item_requirement").m_130940_(ChatFormatting.DARK_PURPLE));
                    for (Aptitudes aptitudes : aptitudesList) {
                        Aptitude aptitude = aptitudes.getAptitude();
                        if (aptitude == null) continue;
                        ChatFormatting colour = AptitudeCapability.get().getAptitudeLevel(aptitude) >= aptitudes.getAptitudeLvl() ? ChatFormatting.GREEN : ChatFormatting.RED;
                        tooltips.add(Component.m_237110_((String)"tooltip.aptitude.item_requirements", (Object[])new Object[]{Component.m_237115_((String)aptitude.getKey()).m_130940_(ChatFormatting.DARK_AQUA), Component.m_237113_((String)String.valueOf(aptitudes.getAptitudeLvl())).m_130940_(colour)}).m_130940_(ChatFormatting.GRAY));
                    }
                }
                return;
            }
            List<Aptitudes> list = HandlerAptitude.getValue(location.toString());
            if (list != null) {
                tooltips.add(Component.m_237119_());
                tooltips.add(Component.m_237115_((String)"tooltip.aptitude.item_requirement").m_130940_(ChatFormatting.DARK_PURPLE));
                for (Aptitudes aptitudes : list) {
                    Aptitude aptitude = aptitudes.getAptitude();
                    if (aptitude == null) continue;
                    ChatFormatting colour = AptitudeCapability.get().getAptitudeLevel(aptitude) >= aptitudes.getAptitudeLvl() ? ChatFormatting.GREEN : ChatFormatting.RED;
                    tooltips.add(Component.m_237110_((String)"tooltip.aptitude.item_requirements", (Object[])new Object[]{Component.m_237115_((String)aptitude.getKey()), Component.m_237113_((String)String.valueOf(aptitudes.getAptitudeLvl())).m_130940_(colour)}));
                }
            }
        }
    }
}

