/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.network.packet.client;

import com.seniors.justlevelingfork.JustLevelingFork;
import com.seniors.justlevelingfork.config.models.LockItem;
import com.seniors.justlevelingfork.handler.HandlerAptitude;
import com.seniors.justlevelingfork.handler.HandlerLockItemsConfig;
import com.seniors.justlevelingfork.network.ServerNetworking;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ConfigSyncCP {
    private final byte[] stringListBytes;

    public ConfigSyncCP(byte[] array) {
        this.stringListBytes = array;
    }

    public ConfigSyncCP(FriendlyByteBuf buffer) {
        int readableBytes = buffer.readableBytes();
        this.stringListBytes = new byte[readableBytes];
        buffer.readBytes(this.stringListBytes);
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeBytes(this.stringListBytes);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            if (localPlayer != null) {
                List lockItemsStrings = new ArrayList();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.stringListBytes);
                try (ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);){
                    lockItemsStrings = (List)objectInputStream.readObject();
                }
                catch (IOException | ClassNotFoundException e) {
                    JustLevelingFork.getLOGGER().error(">> Error writing config to the client. Exception: {}", (Object)e.getMessage());
                }
                ArrayList<LockItem> lockItemList = new ArrayList<LockItem>();
                lockItemsStrings.forEach(c -> lockItemList.add(LockItem.getLockItemFromString(c, new LockItem())));
                HandlerAptitude.UpdateLockItems(lockItemList);
            }
        });
        context.setPacketHandled(true);
    }

    public static void sendToPlayer(Player player) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ArrayList<String> stringList = new ArrayList<String>();
        for (LockItem lockItem : ((HandlerLockItemsConfig)HandlerLockItemsConfig.HANDLER.instance()).lockItemList) {
            stringList.add(lockItem.toString());
        }
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            objectOutputStream.writeObject(stringList);
        }
        catch (IOException e) {
            JustLevelingFork.getLOGGER().error(">> Error sending configuration to the client. Exception: {}", (Object)e.getMessage());
        }
        ServerNetworking.sendToPlayer(new ConfigSyncCP(byteArrayOutputStream.toByteArray()), (ServerPlayer)player);
    }
}

