/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.handler;

import com.seniors.justlevelingfork.common.capability.AptitudeCapability;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.event.CurioEquipEvent;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class HandlerCurios {
    public static boolean isModLoaded() {
        return ModList.get().isLoaded("curios");
    }

    @SubscribeEvent
    public void onCurioCanEquipEvent(CurioEquipEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && !(player = (ServerPlayer)livingEntity).m_7500_()) {
            ItemStack item = event.getStack();
            AptitudeCapability aptitudeCapability = AptitudeCapability.get((Player)player);
            if (aptitudeCapability == null) {
                return;
            }
            try {
                if (!aptitudeCapability.canUseItem((Player)player, item)) {
                    event.setResult(Event.Result.DENY);
                }
            }
            catch (NullPointerException ignored) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangeGameModeEvent(PlayerEvent.PlayerChangeGameModeEvent event) {
        if (!HandlerCurios.isModLoaded()) {
            return;
        }
        if (event.getNewGameMode() == GameType.SURVIVAL) {
            Player player = event.getEntity();
            AptitudeCapability aptitudeCapability = AptitudeCapability.get(player);
            if (aptitudeCapability == null) {
                return;
            }
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInventory -> curiosInventory.getCurios().forEach((id, slotInventory) -> {
                IDynamicStackHandler stackHandler = slotInventory.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack itemStack = stackHandler.getStackInSlot(i);
                    if (aptitudeCapability.canUseItem(player, itemStack)) continue;
                    player.m_36176_(itemStack, false);
                    itemStack.m_41764_(0);
                    stackHandler.setStackInSlot(i, ItemStack.f_41583_);
                    curiosInventory.clearSlotModifiers();
                }
            }));
        }
    }
}

