/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.handler;

import com.seniors.justlevelingfork.config.conditions.AdvancementCondition;
import com.seniors.justlevelingfork.config.conditions.AptitudeCondition;
import com.seniors.justlevelingfork.config.conditions.BlockMinedCondition;
import com.seniors.justlevelingfork.config.conditions.ConditionImpl;
import com.seniors.justlevelingfork.config.conditions.DimensionCondition;
import com.seniors.justlevelingfork.config.conditions.EntityKilledByCondition;
import com.seniors.justlevelingfork.config.conditions.EntityKilledCondition;
import com.seniors.justlevelingfork.config.conditions.ItemBrokenCondition;
import com.seniors.justlevelingfork.config.conditions.ItemCraftedCondition;
import com.seniors.justlevelingfork.config.conditions.ItemDroppedCondition;
import com.seniors.justlevelingfork.config.conditions.ItemPickedUpCondition;
import com.seniors.justlevelingfork.config.conditions.ItemUsedCondition;
import com.seniors.justlevelingfork.config.conditions.StatCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class HandlerConditions {
    private static final List<ConditionImpl<?>> Conditions = new ArrayList();

    public static void registerDefaults() {
        HandlerConditions.registerCondition(new AptitudeCondition());
        HandlerConditions.registerCondition(new DimensionCondition());
        HandlerConditions.registerCondition(new EntityKilledCondition());
        HandlerConditions.registerCondition(new EntityKilledByCondition());
        HandlerConditions.registerCondition(new StatCondition());
        HandlerConditions.registerCondition(new BlockMinedCondition());
        HandlerConditions.registerCondition(new ItemCraftedCondition());
        HandlerConditions.registerCondition(new ItemUsedCondition());
        HandlerConditions.registerCondition(new ItemBrokenCondition());
        HandlerConditions.registerCondition(new ItemPickedUpCondition());
        HandlerConditions.registerCondition(new ItemDroppedCondition());
        HandlerConditions.registerCondition(new AdvancementCondition());
    }

    public static void registerCondition(ConditionImpl<?> condition) {
        if (Conditions.stream().anyMatch(c -> c.getConditionName().equalsIgnoreCase(condition.getConditionName()))) {
            throw new IllegalArgumentException(String.format("Condition with name %s already exists!", condition.getConditionName()));
        }
        Conditions.add(condition);
    }

    public static Optional<ConditionImpl<?>> getConditionByName(String conditionName) {
        return Conditions.stream().filter(c -> c.getConditionName().equalsIgnoreCase(conditionName)).findFirst();
    }
}

