/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.config.models;

import com.seniors.justlevelingfork.JustLevelingFork;
import com.seniors.justlevelingfork.config.conditions.ConditionImpl;
import com.seniors.justlevelingfork.handler.HandlerConditions;
import com.seniors.justlevelingfork.registry.title.Title;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class TitleModel {
    public String TitleId;
    public List<String> Conditions = new ArrayList<String>();
    public boolean Default;
    public Boolean HideRequirements = false;
    private transient Title _title;

    public Title getTitle() {
        return this._title;
    }

    public TitleModel() {
        this.TitleId = "rookie";
        this.Conditions = new ArrayList<String>();
        this.Default = true;
        this.HideRequirements = false;
    }

    public TitleModel(String titleID, List<String> conditions, boolean isDefault) {
        this.TitleId = titleID;
        this.Conditions = conditions;
        this.Default = isDefault;
        this.HideRequirements = false;
    }

    public TitleModel(String titleID, List<String> conditions, boolean isDefault, boolean hideRequirements) {
        this.TitleId = titleID;
        this.Conditions = conditions;
        this.Default = isDefault;
        this.HideRequirements = hideRequirements;
    }

    public String toString() {
        return String.format("%s:%s:%s", this.TitleId, String.join((CharSequence)"=", this.Conditions), this.Default);
    }

    public boolean CheckRequirements(ServerPlayer serverPlayer) {
        if (this.Default) {
            return true;
        }
        int passedConditions = 0;
        for (String condition : this.Conditions) {
            EComparator comparator;
            String[] split = condition.split("/");
            if (split.length != 4) {
                JustLevelingFork.getLOGGER().error(">> Error! Title {} have a wrong formatted condition. (General)", (Object)this.TitleId);
                continue;
            }
            try {
                comparator = EComparator.valueOf(split[2].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                JustLevelingFork.getLOGGER().error(">> Error! Title {} have a wrong formatted condition. (Comparator)", (Object)this.TitleId);
                continue;
            }
            Optional<ConditionImpl<?>> conditionImpl = HandlerConditions.getConditionByName(split[0]);
            if (conditionImpl.isEmpty()) {
                JustLevelingFork.getLOGGER().error(">> Error! Title {} have a wrong formatted condition. (Condition type or Comparator)", (Object)this.TitleId);
                continue;
            }
            conditionImpl.get().ProcessVariable(split[1], serverPlayer);
            if (!conditionImpl.get().MeetCondition(split[3], comparator)) continue;
            passedConditions = (byte)(passedConditions + 1);
        }
        return passedConditions == this.Conditions.size();
    }

    public RegistryObject<Title> registry(DeferredRegister<Title> TITLES) {
        this._title = this.register(this.TitleId, this.Default);
        return TITLES.register(this.TitleId, () -> this._title);
    }

    private Title register(String name, boolean requirement) {
        ResourceLocation key = new ResourceLocation("justlevelingfork", name);
        return new Title(key, requirement, this.HideRequirements);
    }

    private boolean Compare(int a, int b, EComparator comparator) {
        return switch (comparator) {
            case EComparator.EQUALS -> {
                if (a == b) {
                    yield true;
                }
                yield false;
            }
            case EComparator.GREATER -> {
                if (a > b) {
                    yield true;
                }
                yield false;
            }
            case EComparator.LESS -> {
                if (a < b) {
                    yield true;
                }
                yield false;
            }
            case EComparator.GREATER_OR_EQUAL -> {
                if (a >= b) {
                    yield true;
                }
                yield false;
            }
            case EComparator.LESS_OR_EQUAL -> {
                if (a <= b) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static enum EComparator {
        EQUALS,
        GREATER,
        LESS,
        GREATER_OR_EQUAL,
        LESS_OR_EQUAL;

    }

    public static enum EConditionType {
        Aptitude,
        Stat,
        EntityKilled,
        Special;

    }
}

