/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.config.models;

import com.seniors.justlevelingfork.JustLevelingFork;
import com.seniors.justlevelingfork.config.models.EAptitude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class LockItem {
    public String Item = "minecraft:diamond";
    public List<Aptitude> Aptitudes = List.of(new Aptitude());

    public LockItem() {
    }

    public LockItem(String itemName) {
        this.Item = itemName;
    }

    public LockItem(String itemName, Aptitude ... aptitudes) {
        this.Item = itemName;
        this.Aptitudes = Arrays.stream(aptitudes).toList();
    }

    public static LockItem getLockItemFromString(String value, LockItem defaultValue) {
        try {
            return LockItem.formatString(value);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    private static LockItem formatString(String value) {
        String[] aptitudeSplit;
        String[] initialSplit = value.split("#");
        LockItem lockItem = new LockItem(initialSplit[0]);
        ArrayList<Aptitude> aptitudeList = new ArrayList<Aptitude>();
        for (String aptitudeString : aptitudeSplit = initialSplit[1].split(";")) {
            String[] aptitude = aptitudeString.split(":");
            int level = Integer.parseInt(aptitude[1]);
            if (level < 2 || level > 1000) {
                throw new IndexOutOfBoundsException();
            }
            aptitudeList.add(new Aptitude(aptitude[0], level));
        }
        lockItem.Aptitudes = aptitudeList;
        return lockItem;
    }

    public String toString() {
        if (this.Aptitudes.stream().anyMatch(Objects::isNull)) {
            JustLevelingFork.getLOGGER().info(">> Found null aptitude at item {}", (Object)this.Item);
        }
        List<Object> strings = new ArrayList();
        try {
            strings = this.Aptitudes.stream().map(Aptitude::toString).toList();
        }
        catch (NullPointerException e) {
            JustLevelingFork.getLOGGER().info(">> Found null aptitude at item {}", (Object)this.Item);
        }
        String aptitudeStringList = String.join((CharSequence)";", strings);
        return String.format("%s#%s", this.Item, aptitudeStringList);
    }

    public static class Aptitude {
        public EAptitude Aptitude;
        public int Level;

        public Aptitude(String aptitudeName, int level) {
            try {
                this.Aptitude = EAptitude.valueOf(StringUtils.capitalize((String)aptitudeName));
            }
            catch (IllegalArgumentException e) {
                JustLevelingFork.getLOGGER().info(">> Wrong aptitude name {}", (Object)aptitudeName);
                this.Aptitude = EAptitude.Strength;
            }
            this.Level = level;
        }

        public Aptitude() {
            this.Aptitude = EAptitude.Strength;
            this.Level = 2;
        }

        public String toString() {
            return String.format("%s:%d", this.Aptitude.toString(), this.Level);
        }
    }
}

