/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.seniors.justlevelingfork.common.command.arguments.AptitudeArgument;
import com.seniors.justlevelingfork.config.models.LockItem;
import com.seniors.justlevelingfork.handler.HandlerLockItemsConfig;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class RegisterItem {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"registeritem").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"aptitude", (ArgumentType)AptitudeArgument.getArgument()).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(RegisterItem::execute))));
    }

    private static int execute(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)command.getSource()).m_81373_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack stack = player.m_21205_();
            if (stack == ItemStack.f_41583_ || stack.m_41619_()) {
                player.m_213846_((Component)Component.m_237113_((String)"No item detected in main hand!"));
                return 1;
            }
            ResourceLocation location = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
            String aptitudeName = (String)command.getArgument("aptitude", String.class);
            Integer level = (Integer)command.getArgument("level", Integer.class);
            Optional<LockItem> optionalLockItem = ((HandlerLockItemsConfig)HandlerLockItemsConfig.HANDLER.instance()).lockItemList.stream().filter(c -> c.Item.equalsIgnoreCase(location.toString())).findFirst();
            if (optionalLockItem.isPresent()) {
                LockItem lockItem = optionalLockItem.get();
                int index = ((HandlerLockItemsConfig)HandlerLockItemsConfig.HANDLER.instance()).lockItemList.indexOf(lockItem);
                if (level < 1) {
                    if (lockItem.Aptitudes.size() <= 1) {
                        ((HandlerLockItemsConfig)HandlerLockItemsConfig.HANDLER.instance()).lockItemList.remove(index);
                        player.m_213846_((Component)Component.m_237113_((String)"Removing item from lockItemList..."));
                    } else {
                        Optional<LockItem.Aptitude> aptitude = lockItem.Aptitudes.stream().filter(c -> c.Aptitude.toString().equalsIgnoreCase(aptitudeName)).findFirst();
                        aptitude.ifPresent(value -> lockItem.Aptitudes.remove(value));
                        ((HandlerLockItemsConfig)HandlerLockItemsConfig.HANDLER.instance()).lockItemList.set(index, lockItem);
                        player.m_213846_((Component)Component.m_237113_((String)"Removing aptitude from item..."));
                    }
                    HandlerLockItemsConfig.HANDLER.save();
                    return 1;
                }
                lockItem.Aptitudes.stream().filter(c -> c.Aptitude.toString().equalsIgnoreCase(aptitudeName)).findFirst().ifPresent(value -> lockItem.Aptitudes.remove(value));
                lockItem.Aptitudes.add(new LockItem.Aptitude(aptitudeName, level));
                ((HandlerLockItemsConfig)HandlerLockItemsConfig.HANDLER.instance()).lockItemList.set(index, lockItem);
                HandlerLockItemsConfig.HANDLER.save();
                player.m_213846_((Component)Component.m_237113_((String)"Item already in lockItemList, adding extra aptitude..."));
                return 1;
            }
            LockItem lockItem = new LockItem(location.toString());
            lockItem.Aptitudes = new ArrayList<LockItem.Aptitude>();
            lockItem.Aptitudes.add(new LockItem.Aptitude(aptitudeName, level));
            ((HandlerLockItemsConfig)HandlerLockItemsConfig.HANDLER.instance()).lockItemList.add(lockItem);
            HandlerLockItemsConfig.HANDLER.save();
            player.m_213846_((Component)Component.m_237113_((String)"Item added into lockItemList..."));
        }
        return 1;
    }
}

