/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.common.capability;

import com.seniors.justlevelingfork.client.core.Aptitudes;
import com.seniors.justlevelingfork.client.gui.OverlayAptitudeGui;
import com.seniors.justlevelingfork.handler.HandlerAptitude;
import com.seniors.justlevelingfork.handler.HandlerCommonConfig;
import com.seniors.justlevelingfork.network.packet.client.AptitudeOverlayCP;
import com.seniors.justlevelingfork.registry.RegistryAptitudes;
import com.seniors.justlevelingfork.registry.RegistryCapabilities;
import com.seniors.justlevelingfork.registry.RegistryPassives;
import com.seniors.justlevelingfork.registry.RegistrySkills;
import com.seniors.justlevelingfork.registry.RegistryTitles;
import com.seniors.justlevelingfork.registry.aptitude.Aptitude;
import com.seniors.justlevelingfork.registry.passive.Passive;
import com.seniors.justlevelingfork.registry.skills.Skill;
import com.seniors.justlevelingfork.registry.title.Title;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;

public class AptitudeCapability
implements INBTSerializable<CompoundTag> {
    public Map<String, Integer> aptitudeLevel = this.mapAptitudes();
    public Map<String, Integer> passiveLevel = this.mapPassive();
    public Map<String, Boolean> toggleSkill = this.mapSkills();
    public Map<String, Boolean> unlockTitle = this.mapTitles();
    public String playerTitle = RegistryTitles.getTitle("titleless").getName();
    public double betterCombatEntityRange = 0.0;
    public int counterAttackTimer = 0;
    public boolean counterAttack = false;

    private Map<String, Integer> mapAptitudes() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List aptitudeList = RegistryAptitudes.APTITUDES_REGISTRY.get().getValues().stream().toList();
        for (Aptitude aptitude : aptitudeList) {
            map.put(aptitude.getName(), 1);
        }
        return map;
    }

    private Map<String, Integer> mapPassive() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List passiveList = RegistryPassives.PASSIVES_REGISTRY.get().getValues().stream().toList();
        for (Passive passive : passiveList) {
            map.put(passive.getName(), 0);
        }
        return map;
    }

    private Map<String, Boolean> mapSkills() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        List skillList = RegistrySkills.SKILLS_REGISTRY.get().getValues().stream().toList();
        for (Skill skill : skillList) {
            map.put(skill.getName(), false);
        }
        return map;
    }

    private Map<String, Boolean> mapTitles() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        List titleList = RegistryTitles.TITLES_REGISTRY.get().getValues().stream().toList();
        for (Title title : titleList) {
            map.put(title.getName(), title.Requirement);
        }
        return map;
    }

    public boolean getCounterAttack() {
        return this.counterAttack;
    }

    public void setCounterAttack(boolean set) {
        this.counterAttack = set;
    }

    public int getCounterAttackTimer() {
        return this.counterAttackTimer;
    }

    public void setCounterAttackTimer(int timer) {
        this.counterAttackTimer = timer;
    }

    @Nullable
    public static AptitudeCapability get(Player player) {
        LazyOptional capability = player.getCapability(RegistryCapabilities.APTITUDE);
        if (capability.isPresent() && capability.resolve().isPresent()) {
            return (AptitudeCapability)capability.resolve().get();
        }
        return null;
    }

    @Nullable
    public static AptitudeCapability get() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return null;
        }
        return (AptitudeCapability)player.getCapability(RegistryCapabilities.APTITUDE).orElseThrow(() -> new IllegalArgumentException("Player does not have Capabilities!"));
    }

    public int getAptitudeLevel(Aptitude aptitude) {
        return this.aptitudeLevel.get(aptitude.getName());
    }

    public int getAptitudeLevel(String aptitudeName) {
        return this.aptitudeLevel.get(aptitudeName);
    }

    public void setAptitudeLevel(Aptitude aptitude, int lvl) {
        this.aptitudeLevel.put(aptitude.getName(), lvl);
    }

    public int getGlobalLevel() {
        return this.aptitudeLevel.values().stream().mapToInt(Integer::intValue).sum();
    }

    public void addAptitudeLevel(Aptitude aptitude, int addLvl) {
        this.aptitudeLevel.put(aptitude.getName(), Math.min(this.aptitudeLevel.get(aptitude.getName()) + addLvl, ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).aptitudeMaxLevel));
    }

    public int getPassiveLevel(Passive passive) {
        return this.passiveLevel.get(passive.getName());
    }

    public void addPassiveLevel(Passive passive, int addLvl) {
        this.passiveLevel.put(passive.getName(), Math.min(this.passiveLevel.get(passive.getName()) + addLvl, passive.levelsRequired.length));
    }

    public void subPassiveLevel(Passive passive, int subLvl) {
        this.passiveLevel.put(passive.getName(), Math.max(this.passiveLevel.get(passive.getName()) - subLvl, 0));
    }

    public boolean getToggleSkill(Skill skill) {
        return this.toggleSkill.get(skill.getName());
    }

    public void setToggleSkill(Skill skill, boolean toggle) {
        this.toggleSkill.put(skill.getName(), toggle);
    }

    public boolean getLockTitle(Title title) {
        return this.unlockTitle.get(title.getName());
    }

    public void setUnlockTitle(Title title, boolean requirement) {
        this.unlockTitle.put(title.getName(), requirement);
    }

    public String getPlayerTitle() {
        return this.playerTitle;
    }

    public void setPlayerTitle(Title title) {
        this.playerTitle = title.getName();
    }

    public boolean canUseItem(Player player, ItemStack item) {
        return this.canUse(player, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_())));
    }

    public boolean canUseItem(Player player, ResourceLocation resourceLocation) {
        return this.canUse(player, resourceLocation);
    }

    public boolean canUseItemClient(ItemStack item) {
        return this.canUseClient(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_())));
    }

    public boolean canUseSpecificID(Player player, String specificID) {
        return this.canUse(player, specificID);
    }

    public boolean canUseBlock(Player player, Block block) {
        return this.canUse(player, Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)));
    }

    public boolean canUseEntity(Player player, Entity entity) {
        return this.canUse(player, Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_())));
    }

    private boolean canUse(Player player, ResourceLocation resource) {
        List<Aptitudes> aptitude = HandlerAptitude.getValue(resource.toString());
        if (aptitude != null) {
            for (Aptitudes aptitudes : aptitude) {
                if (this.getAptitudeLevel(aptitudes.getAptitude()) >= aptitudes.getAptitudeLvl()) continue;
                if (player instanceof ServerPlayer) {
                    AptitudeOverlayCP.send(player, resource.toString());
                }
                return false;
            }
        }
        return true;
    }

    private boolean canUseClient(ResourceLocation resource) {
        List<Aptitudes> aptitude = HandlerAptitude.getValue(resource.toString());
        if (aptitude != null) {
            for (Aptitudes aptitudes : aptitude) {
                if (this.getAptitudeLevel(aptitudes.getAptitude()) >= aptitudes.getAptitudeLvl()) continue;
                OverlayAptitudeGui.showWarning(resource.toString());
                return false;
            }
        }
        return true;
    }

    private boolean canUse(Player player, String restrictionID) {
        List<Aptitudes> aptitude = HandlerAptitude.getValue(restrictionID);
        if (aptitude != null) {
            for (Aptitudes aptitudes : aptitude) {
                if (this.getAptitudeLevel(aptitudes.getAptitude()) >= aptitudes.getAptitudeLvl()) continue;
                if (player instanceof ServerPlayer) {
                    AptitudeOverlayCP.send(player, restrictionID);
                }
                return false;
            }
        }
        return true;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        for (Aptitude aptitude : RegistryAptitudes.APTITUDES_REGISTRY.get().getValues().stream().toList()) {
            nbt.m_128405_("aptitude." + aptitude.getName(), this.aptitudeLevel.get(aptitude.getName()).intValue());
        }
        for (Passive passive : RegistryPassives.PASSIVES_REGISTRY.get().getValues().stream().toList()) {
            nbt.m_128405_("passive." + passive.getName(), this.passiveLevel.get(passive.getName()).intValue());
        }
        for (Skill skill : RegistrySkills.SKILLS_REGISTRY.get().getValues().stream().toList()) {
            nbt.m_128379_("skill." + skill.getName(), this.toggleSkill.get(skill.getName()).booleanValue());
        }
        for (Title title : RegistryTitles.TITLES_REGISTRY.get().getValues().stream().toList()) {
            nbt.m_128379_("title." + title.getName(), this.unlockTitle.get(title.getName()).booleanValue());
        }
        nbt.m_128405_("counterAttackTimer", this.counterAttackTimer);
        nbt.m_128379_("counterAttack", this.counterAttack);
        nbt.m_128359_("playerTitle", this.playerTitle);
        nbt.m_128347_("betterCombatEntityRange", this.betterCombatEntityRange);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (Aptitude aptitude : RegistryAptitudes.APTITUDES_REGISTRY.get().getValues().stream().toList()) {
            this.aptitudeLevel.put(aptitude.getName(), nbt.m_128451_("aptitude." + aptitude.getName()));
        }
        for (Passive passive : RegistryPassives.PASSIVES_REGISTRY.get().getValues().stream().toList()) {
            this.passiveLevel.put(passive.getName(), nbt.m_128451_("passive." + passive.getName()));
        }
        for (Skill skill : RegistrySkills.SKILLS_REGISTRY.get().getValues().stream().toList()) {
            this.toggleSkill.put(skill.getName(), nbt.m_128471_("skill." + skill.getName()));
        }
        for (Title title : RegistryTitles.TITLES_REGISTRY.get().getValues().stream().toList()) {
            this.unlockTitle.put(title.getName(), nbt.m_128471_("title." + title.getName()));
        }
        this.counterAttackTimer = nbt.m_128451_("counterAttackTimer");
        this.counterAttack = nbt.m_128471_("counterAttack");
        this.playerTitle = nbt.m_128461_("playerTitle");
        this.betterCombatEntityRange = nbt.m_128459_("betterCombatEntityRange");
    }

    public void copyFrom(AptitudeCapability source) {
        for (Aptitude aptitude : RegistryAptitudes.APTITUDES_REGISTRY.get().getValues().stream().toList()) {
            this.aptitudeLevel.put(aptitude.getName(), source.aptitudeLevel.get(aptitude.getName()));
        }
        for (Passive passive : RegistryPassives.PASSIVES_REGISTRY.get().getValues().stream().toList()) {
            this.passiveLevel.put(passive.getName(), source.passiveLevel.get(passive.getName()));
        }
        for (Skill skill : RegistrySkills.SKILLS_REGISTRY.get().getValues().stream().toList()) {
            this.toggleSkill.put(skill.getName(), source.toggleSkill.get(skill.getName()));
        }
        for (Title title : RegistryTitles.TITLES_REGISTRY.get().getValues().stream().toList()) {
            this.unlockTitle.put(title.getName(), source.unlockTitle.get(title.getName()));
        }
        this.counterAttackTimer = source.counterAttackTimer;
        this.counterAttack = source.counterAttack;
        this.playerTitle = source.playerTitle;
        this.betterCombatEntityRange = source.betterCombatEntityRange;
    }
}

