/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.seniors.justlevelingfork.client.core.Aptitudes;
import com.seniors.justlevelingfork.client.core.Utils;
import com.seniors.justlevelingfork.common.capability.AptitudeCapability;
import com.seniors.justlevelingfork.handler.HandlerAptitude;
import com.seniors.justlevelingfork.registry.RegistryCapabilities;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class OverlayAptitudeGui {
    private final Minecraft client = Minecraft.m_91087_();
    private static List<Aptitudes> aptitudes = null;
    private static int showTicks = 0;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onHudRender(CustomizeGuiOverlayEvent.DebugText event) {
        GuiGraphics matrixStack = event.getGuiGraphics();
        if (this.client.f_91073_ != null && this.client.f_91074_ != null && showTicks > 0 && this.client.f_91074_.getCapability(RegistryCapabilities.APTITUDE).isPresent()) {
            matrixStack.m_280168_().m_85836_();
            int xOff = this.client.m_91268_().m_85445_() / 2;
            int yOff = this.client.m_91268_().m_85446_() / 4;
            MutableComponent overlayMessage = Component.m_237115_((String)"overlay.aptitude.message");
            int overlayWidth = this.client.f_91062_.m_92852_((FormattedText)overlayMessage) / 2;
            RenderSystem.enableBlend();
            for (int i = 0; i < 16; ++i) {
                float f = showTicks < 40 ? 0.003f * (float)i / 40.0f * (float)showTicks : 0.003f * (float)i;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f);
                matrixStack.m_280509_(xOff - overlayWidth - 14 - 16 - i, yOff - 11 - 16 - i, xOff + overlayWidth + 14 + 16 - i, yOff + 45 + 16 - i, Color.BLACK.getRGB());
            }
            float alpha = showTicks < 40 ? 0.025f * (float)showTicks : 1.0f;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            Utils.drawCenterWithShadow(matrixStack, (Component)overlayMessage, xOff, yOff, 0xFF5555);
            for (int j = 0; j < aptitudes.size(); ++j) {
                Aptitudes abilities = aptitudes.get(j);
                String level = Integer.toString(abilities.getAptitudeLvl());
                boolean met = AptitudeCapability.get().getAptitudeLevel(abilities.getAptitude()) >= abilities.getAptitudeLvl();
                int x = xOff + j * 24 - aptitudes.size() * 12;
                int y = yOff + 15;
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                matrixStack.m_280163_(abilities.getAptitude().getLockedTexture(abilities.getAptitudeLvl()), x, y, 0.0f, 0.0f, 16, 16, 16, 16);
                Utils.drawCenterWithShadow(matrixStack, level, x + 16, y + 12, met ? 0x55FF55 : 0xFF5555);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.m_280168_().m_85849_();
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (showTicks > 0) {
            --showTicks;
        }
    }

    public static void showWarning(String aptitude) {
        aptitudes = HandlerAptitude.getValue(aptitude);
        showTicks = 90;
    }
}

