/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork.client.core;

import com.mojang.authlib.GameProfile;
import com.seniors.justlevelingfork.registry.RegistrySounds;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;

public class Utils {
    public static int FONT_COLOR = new Color(62, 62, 62).getRGB();
    public static final Minecraft client = Minecraft.m_91087_();

    public static ItemStack playerHead() {
        ItemStack head = new ItemStack((ItemLike)Items.f_42680_);
        if (Utils.client.f_91074_ != null) {
            if (Utils.client.f_91074_.m_36316_().getProperties().isEmpty()) {
                return head;
            }
            CompoundTag nbt = head.m_41784_();
            GameProfile gameProfile = Utils.client.f_91074_.m_36316_();
            SkullBlockEntity.m_155738_((GameProfile)gameProfile, profile -> nbt.m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)profile)));
            head.m_41751_(nbt);
        }
        return head;
    }

    public static void playSound() {
        client.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public static void drawToolTip(GuiGraphics matrixStack, Component tooltip, int mouseX, int mouseY) {
        matrixStack.m_280557_(Utils.client.f_91062_, tooltip, mouseX, mouseY);
    }

    public static void drawToolTipList(GuiGraphics matrixStack, List<Component> tooltip, int mouseX, int mouseY) {
        matrixStack.m_280677_(Utils.client.f_91062_, tooltip, Optional.empty(), mouseX, mouseY);
    }

    public static boolean checkMouse(int x, int y, int mouseX, int mouseY, int width, int height) {
        return x <= mouseX && x + width >= mouseX && y <= mouseY && y + height >= mouseY;
    }

    public static String numberFormat(int number) {
        return String.format("%02d", number);
    }

    public static void drawCenter(GuiGraphics matrixStack, Component string, int x, int y) {
        matrixStack.m_280614_(Utils.client.f_91062_, string, x - Utils.client.f_91062_.m_92852_((FormattedText)string) / 2, y, FONT_COLOR, false);
    }

    public static void drawCenterWithShadow(GuiGraphics matrixStack, String string, int x, int y, int color) {
        matrixStack.m_280056_(Utils.client.f_91062_, string, x - Utils.client.f_91062_.m_92895_(string) / 2, y, color, true);
    }

    public static void drawCenterWithShadow(GuiGraphics matrixStack, Component string, int x, int y, int color) {
        matrixStack.m_280614_(Utils.client.f_91062_, string, x - Utils.client.f_91062_.m_92852_((FormattedText)string) / 2, y, color, true);
    }

    public static String intToRoman(int number) {
        String[] thousands = new String[]{"", "M", "MM", "MMM"};
        String[] hundreds = new String[]{"", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM"};
        String[] tens = new String[]{"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};
        String[] units = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};
        return thousands[number / 1000] + thousands[number / 1000] + hundreds[number % 1000 / 100] + tens[number % 100 / 10];
    }

    public static String periodValue(double value) {
        DecimalFormat df = new DecimalFormat("#.#");
        String number = String.valueOf(value);
        if (number.contains(".")) {
            String decimal = number.split("\\.")[1];
            int zero = 1;
            for (int i = 0; i < decimal.length(); ++i) {
                if (decimal.charAt(i) != '0') continue;
                ++zero;
            }
            String format = "#." + "#".repeat(zero);
            return new DecimalFormat(format).format(value);
        }
        return df.format(value);
    }

    public static String getModName(String modId) {
        AtomicReference<String> modName = new AtomicReference<String>("Misspelled Mod");
        if (modId != null) {
            ModList.get().getModContainerById(modId).ifPresent(modContainer -> modName.set(modContainer.getModInfo().getDisplayName()));
        }
        return modName.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void getTitleSound() {
        client.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)RegistrySounds.GAIN_TITLE.get()), (float)1.0f));
    }

    public static int getPlayerXP(Player player) {
        return (int)((float)Utils.getExperienceForLevel(player.f_36078_) + player.f_36080_ * (float)player.m_36323_());
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return Utils.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + Utils.sum(level - 15, 37, 5);
        }
        return 1395 + Utils.sum(level - 30, 112, 9);
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }
}

