/*
 * Decompiled with CFR 0.152.
 */
package com.seniors.justlevelingfork;

import com.mojang.logging.LogUtils;
import com.seniors.justlevelingfork.config.Configuration;
import com.seniors.justlevelingfork.config.models.EAptitude;
import com.seniors.justlevelingfork.config.models.LockItem;
import com.seniors.justlevelingfork.handler.HandlerCommonConfig;
import com.seniors.justlevelingfork.handler.HandlerConfigCommon;
import com.seniors.justlevelingfork.handler.HandlerCurios;
import com.seniors.justlevelingfork.handler.HandlerLockItemsConfig;
import com.seniors.justlevelingfork.integration.CrayfishGunModIntegration;
import com.seniors.justlevelingfork.integration.IronsSpellsbooksIntegration;
import com.seniors.justlevelingfork.integration.ScorchedGuns2Integration;
import com.seniors.justlevelingfork.integration.TacZIntegration;
import com.seniors.justlevelingfork.network.ServerNetworking;
import com.seniors.justlevelingfork.registry.RegistryAptitudes;
import com.seniors.justlevelingfork.registry.RegistryArguments;
import com.seniors.justlevelingfork.registry.RegistryAttributes;
import com.seniors.justlevelingfork.registry.RegistryCommonEvents;
import com.seniors.justlevelingfork.registry.RegistryItems;
import com.seniors.justlevelingfork.registry.RegistryPassives;
import com.seniors.justlevelingfork.registry.RegistrySkills;
import com.seniors.justlevelingfork.registry.RegistrySounds;
import com.seniors.justlevelingfork.registry.RegistryTitles;
import com.seniors.justlevelingfork.registry.aptitude.Aptitude;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="justlevelingfork")
public class JustLevelingFork {
    public static final String MOD_ID = "justlevelingfork";
    public static final String MOD_NAME = "just_leveling_fork";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static MutablePair<Boolean, String> UpdatesAvailable = new MutablePair((Object)false, (Object)"");
    public static MinecraftServer server;

    public static Logger getLOGGER() {
        return LOGGER;
    }

    public JustLevelingFork() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::attributeSetup);
        Configuration.Init();
        RegistryItems.load(eventBus);
        RegistryAptitudes.load(eventBus);
        RegistryPassives.load(eventBus);
        RegistrySkills.load(eventBus);
        RegistryAttributes.load(eventBus);
        RegistrySounds.load(eventBus);
        RegistryArguments.load(eventBus);
        RegistryTitles.load(eventBus);
        MinecraftForge.EVENT_BUS.register((Object)new RegistryCommonEvents());
        if (HandlerCurios.isModLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)new HandlerCurios());
        }
        if (TacZIntegration.isModLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)new TacZIntegration());
        }
        if (CrayfishGunModIntegration.isModLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)new CrayfishGunModIntegration());
        }
        if (ScorchedGuns2Integration.isModLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)new ScorchedGuns2Integration());
        }
        if (IronsSpellsbooksIntegration.isModLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)new IronsSpellsbooksIntegration());
        }
        ServerNetworking.init();
        if (((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).checkForUpdates) {
            try {
                ModInfo modInfo;
                String version = JustLevelingFork.getLatestVersion();
                Optional<IModInfo> optionalModInfo = ModList.get().getMods().stream().filter(c -> Objects.equals(c.getModId(), MOD_ID)).findFirst();
                if (optionalModInfo.isPresent() && !Objects.equals((modInfo = (ModInfo)optionalModInfo.get()).getVersion().toString(), version)) {
                    JustLevelingFork.UpdatesAvailable.left = true;
                    JustLevelingFork.UpdatesAvailable.right = version;
                    LOGGER.info(">> NEW VERSION AVAILABLE: {}", (Object)version);
                }
            }
            catch (Exception e) {
                LOGGER.warn(">> Error checking for updates!");
            }
        }
    }

    @NotNull
    private static String getLatestVersion() throws IOException {
        String inputLine;
        URL u = new URL("https://raw.githubusercontent.com/Senior-S/JustLeveling-Fork/master/VERSION");
        URLConnection conn = u.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder buffer = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            buffer.append(inputLine);
        }
        in.close();
        return buffer.toString();
    }

    private void attributeSetup(EntityAttributeModificationEvent event) {
        for (EntityType type : event.getTypes()) {
            event.add(type, (Attribute)RegistryAttributes.CRITICAL_DAMAGE.get());
            event.add(type, (Attribute)RegistryAttributes.MAGIC_RESIST.get());
            event.add(type, (Attribute)RegistryAttributes.BREAK_SPEED.get());
            event.add(type, (Attribute)RegistryAttributes.PROJECTILE_DAMAGE.get());
            event.add(type, (Attribute)RegistryAttributes.BENEFICIAL_EFFECT.get());
        }
    }

    public static void migrateOldConfig() {
        List configList = (List)HandlerConfigCommon.lockItemList.get();
        ArrayList<LockItem> items = new ArrayList<LockItem>();
        for (String value : configList) {
            String[] values = value.split("#");
            if (values.length != 2) continue;
            LockItem lockItem = new LockItem(values[0]);
            String getResource = values[0];
            if (getResource.split(":").length != 2) continue;
            String aptitudeValue = values[1];
            String getAptitude = aptitudeValue.contains("<droppable>") ? aptitudeValue.split("<droppable>")[0] : aptitudeValue;
            String[] aptitudeList = getAptitude.split(";");
            ArrayList<LockItem.Aptitude> aptitudes = new ArrayList<LockItem.Aptitude>();
            for (String getMultipleSkill : aptitudeList) {
                Aptitude aptitudeName;
                if (getMultipleSkill.isEmpty() || getMultipleSkill.contains("#") || getMultipleSkill.contains(",")) continue;
                String[] aptitudeValues = getMultipleSkill.split(":");
                String aptitudePath = aptitudeValues[0];
                if (aptitudePath.equals("defence")) {
                    aptitudePath = "defense";
                }
                if ((aptitudeName = RegistryAptitudes.getAptitude(aptitudePath)) == null) continue;
                LockItem.Aptitude aptitude = new LockItem.Aptitude();
                aptitude.Aptitude = EAptitude.valueOf(StringUtils.capitalize((String)aptitudePath));
                aptitude.Level = Integer.parseInt(aptitudeValues[1]);
                aptitudes.add(aptitude);
            }
            if (aptitudes.isEmpty()) continue;
            lockItem.Aptitudes = aptitudes;
            items.add(lockItem);
        }
        items.forEach(item -> {
            if (((HandlerLockItemsConfig)HandlerLockItemsConfig.HANDLER.instance()).lockItemList.stream().noneMatch(lockItem -> lockItem.Item.equalsIgnoreCase(item.Item))) {
                ((HandlerLockItemsConfig)HandlerLockItemsConfig.HANDLER.instance()).lockItemList.add((LockItem)item);
            }
        });
        HandlerLockItemsConfig.HANDLER.save();
        ((HandlerCommonConfig)HandlerCommonConfig.HANDLER.instance()).usingNewConfig = true;
        HandlerCommonConfig.HANDLER.save();
    }
}

