/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.events;

import java.util.List;
import java.util.Objects;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.block.DelightfulBlocks;
import net.brnbrd.delightful.common.block.ISliceable;
import net.brnbrd.delightful.common.item.DelightfulItems;
import net.brnbrd.delightful.compat.Modid;
import net.brnbrd.delightful.compat.SOBCompat;
import net.brnbrd.delightful.data.tags.DelightfulItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.tag.ForgeTags;

public class ForgeEvents {
    @SubscribeEvent
    void onEatEffectProvider(LivingEntityUseItemEvent.Finish e) {
        if (e.getResult() != Event.Result.DENY) {
            ItemStack stack = e.getItem();
            LivingEntity entity = e.getEntity();
            if (Modid.CAD.loaded() && stack.m_204117_(DelightfulItemTags.ROTTEN) && entity.m_217043_().m_188499_()) {
                int duration = 160;
                if (stack.m_150930_(Modid.RL.item("rotten_chunk"))) {
                    duration = 1800;
                }
                Util.addEffect(entity, Modid.CAD.effect("rotten", new MobEffect[0]), duration, 0);
            } else if (Modid.SOB.loaded() && stack.m_204117_(DelightfulItemTags.SPITE)) {
                int duration = 200;
                if (stack.m_150930_(Modid.ECO.item("cooked_prickly_pear"))) {
                    duration = 400;
                }
                Util.addEffect(entity, SOBCompat.getSpite(), duration, 0);
            }
        }
    }

    @SubscribeEvent
    void onWanderingTrader(WandererTradesEvent e) {
        List trades = e.getGenericTrades();
        if (Util.enabled(DelightfulItems.SALMONBERRIES) && Util.enabled(DelightfulItems.SALMONBERRY_PIPS)) {
            trades.add((ent, r) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 2), Util.getStack(DelightfulItems.SALMONBERRY_PIPS, new int[0]), 5, 1, 1.0f));
        }
        if (Util.enabled(DelightfulItems.CANTALOUPE) && Util.enabled(DelightfulItems.CANTALOUPE_SLICE)) {
            trades.add((ent, r) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 3), Util.getStack(DelightfulItems.CANTALOUPE_SLICE, new int[]{8}), 5, 1, 1.0f));
        }
        if (Util.enabled(DelightfulItems.CANTALOUPE) && Util.enabled(DelightfulItems.STUFFED_CANTALOUPE_BLOCK) && Util.enabled(DelightfulItems.STUFFED_CANTALOUPE)) {
            trades.add((ent, r) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), Util.getStack(DelightfulItems.STUFFED_CANTALOUPE_BLOCK, new int[]{1}), 3, 1, 1.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    void onInteract(PlayerInteractEvent.RightClickBlock e) {
        Level level = e.getLevel();
        BlockPos pos = e.getPos();
        if (e.getItemStack().m_204117_(ForgeTags.TOOLS_KNIVES) && !e.getEntity().m_6047_()) {
            Block newBlock;
            Block current = level.m_8055_(pos).m_60734_();
            if (current == Blocks.f_50186_) {
                newBlock = (Block)DelightfulBlocks.SLICED_MELON.get();
            } else if (current == Blocks.f_50133_) {
                newBlock = (Block)DelightfulBlocks.SLICED_PUMPKIN.get();
            } else if (Objects.equals(ForgeRegistries.BLOCKS.getKey((Object)current), Modid.UG.rl("carved_gloomgourd"))) {
                newBlock = (Block)DelightfulBlocks.SLICED_GLOOMGOURD.get();
            } else {
                return;
            }
            if (newBlock instanceof ISliceable) {
                ISliceable slice = (ISliceable)newBlock;
                boolean client = level.m_5776_();
                e.setCancellationResult(InteractionResult.m_19078_((boolean)client));
                e.setCanceled(true);
                if (!client) {
                    this.slice(newBlock.m_49966_(), slice.getSliceItem(), level, pos, e.getEntity(), e.getHand());
                }
            }
        }
    }

    void slice(BlockState block, ItemStack slice, Level world, BlockPos pos, Player player, InteractionHand hand) {
        world.m_7731_(pos, block, 2);
        Util.dropOrGive(slice, world, pos, player);
        world.m_5594_(null, pos, SoundEvents.f_12296_, SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_21120_(hand).m_41622_(1, (LivingEntity)player, onBroken -> {});
    }
}

