/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.unusual.blockfactorysbosses.procedures.SnowCloudParticleVisualScaleProcedure;

@OnlyIn(value=Dist.CLIENT)
public class SoulCloudParticle
extends TextureSheetParticle {
    public static final ParticleRenderType PARTICLE_CLOUD = new ParticleRenderType(){

        public void m_6505_(BufferBuilder builder, TextureManager textureManager) {
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(GameRenderer::m_172829_);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableCull();
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tessellator) {
            tessellator.m_85914_();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableCull();
            RenderSystem.defaultBlendFunc();
        }

        public String toString() {
            return "PARTICLE_CLOUD";
        }
    };
    private final SpriteSet spriteSet;

    public static SoulCloudParticleProvider provider(SpriteSet spriteSet) {
        return new SoulCloudParticleProvider(spriteSet);
    }

    protected SoulCloudParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.m_107250_(0.9f, 0.9f);
        this.f_107225_ = 22 + this.f_107223_.m_188503_(5);
        this.f_107226_ = 0.0f;
        this.f_107219_ = true;
        this.f_107215_ = vx * 0.4;
        this.f_107216_ = vy * 0.4;
        this.f_107217_ = vz * 0.4;
        this.f_107231_ = 0.1f * (float)Math.random();
        this.m_108335_(spriteSet);
        this.m_107271_(0.9f);
        this.f_107227_ = 0.25f;
        this.f_107228_ = 0.415f;
        this.f_107229_ = 0.39f;
    }

    public int m_6355_(float partialTick) {
        return 0xF000F0;
    }

    public ParticleRenderType m_7556_() {
        return PARTICLE_CLOUD;
    }

    public float m_5902_(float scale) {
        return super.m_5902_(scale) * 4.0f * (float)SnowCloudParticleVisualScaleProcedure.execute(this.f_107224_);
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107204_ = this.f_107231_;
        if (this.f_107224_ >= this.f_107225_ - 5 && this.f_107230_ > 0.01f) {
            this.f_107230_ -= 0.12f;
            if (this.f_107230_ < 0.0f) {
                this.f_107230_ = 0.0f;
            }
            this.m_107271_(this.f_107230_);
            float t = (this.f_107225_ - this.f_107224_) / this.f_107225_;
            if (t < 1.0f) {
                this.f_107227_ = 0.02f;
                this.f_107228_ = 0.02f;
                this.f_107229_ = 0.02f;
            } else {
                this.f_107227_ = 0.25f * (1.0f - t) + 0.02f * t;
                this.f_107228_ = 0.415f * (1.0f - t) + 0.02f * t;
                this.f_107229_ = 0.39f * (1.0f - t) + 0.02f * t;
            }
        }
    }

    public static class SoulCloudParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public SoulCloudParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SoulCloudParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

