/*
 * Decompiled with CFR 0.152.
 */
package ua.archijk.wizard_samurai.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.util.EnumMap;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import ua.archijk.wizard_samurai.config.ArmorConfig;
import ua.archijk.wizard_samurai.registries.ItemRegistries;

public enum SamuraiArmorMaterials implements ArmorMaterial
{
    WIZARD_SAMURAI("wizard_samurai", (Integer)ArmorConfig.WizardSamuraiArmorDurability.get(), ArmorConfig.WizardSamuraiArmorValue, (Integer)ArmorConfig.WizardSamuraiArmorEnchantmentValue.get(), SoundEvents.f_11679_, ((Double)ArmorConfig.WizardSamuraiArmorToughness.get()).floatValue(), ((Double)ArmorConfig.WizardSamuraiArmorKnockbackResistance.get()).floatValue(), () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistries.WIZARD_SAMURAI_CHESTPLATE.get()})),
    IGNIS_SAMURAI("ignis_samurai", (Integer)ArmorConfig.IgnisSamuraiArmorDurability.get(), ArmorConfig.IgnisSamuraiArmorValue, (Integer)ArmorConfig.IgnisSamuraiArmorEnchantmentValue.get(), SoundEvents.f_11679_, ((Double)ArmorConfig.IgnisSamuraiArmorToughness.get()).floatValue(), ((Double)ArmorConfig.IgnisSamuraiArmorKnockbackResistance.get()).floatValue(), () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistries.IGNIS_SAMURAI_CHESTPLATE.get()})),
    IGNIS_WIZARD_SAMURAI("ignis_wizard_samurai", (Integer)ArmorConfig.IgnisWizardSamuraiArmorDurability.get(), ArmorConfig.IgnisWizardSamuraiArmorValue, (Integer)ArmorConfig.IgnisWizardSamuraiArmorEnchantmentValue.get(), SoundEvents.f_11679_, ((Double)ArmorConfig.IgnisWizardSamuraiArmorToughness.get()).floatValue(), ((Double)ArmorConfig.IgnisWizardSamuraiArmorKnockbackResistance.get()).floatValue(), () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistries.IGNIS_WIZARD_SAMURAI_CHESTPLATE.get()})),
    SCULK_WIZARD_SAMURAI("sculk_wizard_samurai", (Integer)ArmorConfig.SculkWizardSamuraiArmorDurability.get(), ArmorConfig.SculkWizardSamuraiArmorValue, (Integer)ArmorConfig.SculkWizardSamuraiArmorEnchantmentValue.get(), SoundEvents.f_11679_, ((Double)ArmorConfig.SculkWizardSamuraiArmorToughness.get()).floatValue(), ((Double)ArmorConfig.SculkWizardSamuraiArmorKnockbackResistance.get()).floatValue(), () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistries.SCULK_WIZARD_SAMURAI_CHESTPLATE.get()})),
    AMETHYST_WIZARD_SAMURAI("amethyst_wizard_samurai", (Integer)ArmorConfig.AmethystWizardSamuraiArmorDurability.get(), ArmorConfig.AmethystWizardSamuraiArmorValue, (Integer)ArmorConfig.AmethystWizardSamuraiArmorEnchantmentValue.get(), SoundEvents.f_11679_, ((Double)ArmorConfig.AmethystWizardSamuraiArmorToughness.get()).floatValue(), ((Double)ArmorConfig.AmethystWizardSamuraiArmorKnockbackResistance.get()).floatValue(), () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistries.AMETHYST_WIZARD_SAMURAI_CHESTPLATE.get()})),
    CRIMSON_WIZARD_SAMURAI("crimson_wizard_samurai", (Integer)ArmorConfig.CrimsonWizardSamuraiArmorDurability.get(), ArmorConfig.CrimsonWizardSamuraiArmorValue, (Integer)ArmorConfig.CrimsonWizardSamuraiArmorEnchantmentValue.get(), SoundEvents.f_11679_, ((Double)ArmorConfig.CrimsonWizardSamuraiArmorToughness.get()).floatValue(), ((Double)ArmorConfig.CrimsonWizardSamuraiArmorKnockbackResistance.get()).floatValue(), () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistries.CRIMSON_WIZARD_SAMURAI_CHESTPLATE.get()}));

    private static final int[] HEALTH_PER_SLOT;
    private final String name;
    private final int durabilityMultiplier;
    private final ArmorConfig.ArmorValues protectionFunctionForType;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairIngredient;
    private EnumMap<EquipmentSlot, Multimap<Attribute, AttributeModifier>> slotToAttributeMap;
    private static final UUID[] ARMOR_ATTRIBUTE_UUID_PER_SLOT;
    private static EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE;

    private SamuraiArmorMaterials(String pName, int pDurabilityMultiplier, ArmorConfig.ArmorValues protectionMap, int pEnchantmentValue, SoundEvent pSound, float pToughness, float pKnockbackResistance, Supplier<Ingredient> pRepairIngredient) {
        this.name = pName;
        this.durabilityMultiplier = pDurabilityMultiplier;
        this.protectionFunctionForType = protectionMap;
        this.enchantmentValue = pEnchantmentValue;
        this.sound = pSound;
        this.toughness = pToughness;
        this.knockbackResistance = pKnockbackResistance;
        this.repairIngredient = new LazyLoadedValue(pRepairIngredient);
        this.slotToAttributeMap = null;
    }

    public EnumMap<EquipmentSlot, Multimap<Attribute, AttributeModifier>> getSlotToAttributeMap() {
        if (this.slotToAttributeMap == null) {
            this.slotToAttributeMap = this.makeSlotToAttributeMap();
        }
        return this.slotToAttributeMap;
    }

    private EnumMap<EquipmentSlot, Multimap<Attribute, AttributeModifier>> makeSlotToAttributeMap() {
        return (EnumMap)Util.m_137469_(new EnumMap(EquipmentSlot.class), p_266655_ -> {
            p_266655_.put(EquipmentSlot.FEET, this.makeAttributeMap(EquipmentSlot.FEET));
            p_266655_.put(EquipmentSlot.LEGS, this.makeAttributeMap(EquipmentSlot.LEGS));
            p_266655_.put(EquipmentSlot.CHEST, this.makeAttributeMap(EquipmentSlot.CHEST));
            p_266655_.put(EquipmentSlot.HEAD, this.makeAttributeMap(EquipmentSlot.HEAD));
        });
    }

    private Multimap<Attribute, AttributeModifier> makeAttributeMap(EquipmentSlot slot) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_ATTRIBUTE_UUID_PER_SLOT[slot.m_20749_()];
        int protection = this.protectionFunctionForType.getProtectionValues(slot);
        float toughness = this.toughness;
        float knockbackResistance = this.knockbackResistance;
        double ManaWizardSamurai = ((Integer)ArmorConfig.WizardSamuraiArmorMana.get()).intValue();
        double ManaRegenWizardSamurai = (Double)ArmorConfig.WizardSamuraiArmorManaRegen.get();
        double castSpeedWizardSamurai = (Double)ArmorConfig.WizardSamuraiArmorCastSpeed.get();
        double spellResistanceWizardSamurai = (Double)ArmorConfig.WizardSamuraiArmorSpellResistance.get();
        double spellPowerWizardSamurai = (Double)ArmorConfig.WizardSamuraiArmorSpellPower.get();
        double spellCooldownWizardSamurai = (Double)ArmorConfig.WizardSamuraiArmorSpellCooldown.get();
        double ManaIgnisWizardSamurai = ((Integer)ArmorConfig.IgnisWizardSamuraiArmorMana.get()).intValue();
        double spellResistanceIgnisWizardSamurai = (Double)ArmorConfig.IgnisWizardSamuraiArmorSpellResistance.get();
        double spellPowerIgnisWizardSamurai = (Double)ArmorConfig.IgnisWizardSamuraiArmorSpellPower.get();
        double ManaSculkWizardSamurai = ((Integer)ArmorConfig.SculkWizardSamuraiArmorMana.get()).intValue();
        double spellEldritchWizardSamurai = (Double)ArmorConfig.SculkWizardSamuraiArmorSpellEldritch.get();
        double spellResistanceSculkWizardSamurai = (Double)ArmorConfig.SculkWizardSamuraiArmorSpellResistance.get();
        double ManaAmethystWizardSamurai = ((Integer)ArmorConfig.AmethystWizardSamuraiArmorMana.get()).intValue();
        double ManaRegenAmethystWizardSamurai = (Double)ArmorConfig.AmethystWizardSamuraiArmorManaRegen.get();
        double spellCooldownAmethystWizardSamurai = (Double)ArmorConfig.AmethystWizardSamuraiArmorSpellCooldown.get();
        double castSpeedAmethystWizardSamurai = (Double)ArmorConfig.AmethystWizardSamuraiArmorCastSpeed.get();
        double spellResistanceAmethystWizardSamurai = (Double)ArmorConfig.AmethystWizardSamuraiArmorSpellResistance.get();
        double CrimsonWizardSamuraiArmorMana = ((Integer)ArmorConfig.CrimsonWizardSamuraiArmorMana.get()).intValue();
        double CrimsonWizardSamuraiBloodSpellPower = (Double)ArmorConfig.CrimsonWizardSamuraiArmorBloodSpellPower.get();
        double CrimsonWizardSamuraiBloodMagicResistance = (Double)ArmorConfig.CrimsonWizardSamuraiArmorBloodMagicResistance.get();
        double CrimsonWizardSamuraiSpellResistance = (Double)ArmorConfig.CrimsonWizardSamuraiArmorSpellResistance.get();
        if (protection != 0) {
            builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)protection, AttributeModifier.Operation.ADDITION));
        }
        if (toughness != 0.0f) {
            builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)toughness, AttributeModifier.Operation.ADDITION));
        }
        if (knockbackResistance > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)knockbackResistance, AttributeModifier.Operation.ADDITION));
        }
        if (ManaWizardSamurai != 0.0 && this == WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.MAX_MANA.get()), (Object)new AttributeModifier(uuid, "Armor Mana", ManaWizardSamurai, AttributeModifier.Operation.ADDITION));
        }
        if (ManaRegenWizardSamurai != 0.0 && this == WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.MANA_REGEN.get()), (Object)new AttributeModifier(uuid, "Armor Mana regen", ManaRegenWizardSamurai, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (castSpeedWizardSamurai != 0.0 && this == WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.CAST_TIME_REDUCTION.get()), (Object)new AttributeModifier(uuid, "Base Speed Cast", castSpeedWizardSamurai, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (spellResistanceWizardSamurai != 0.0 && this == WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.SPELL_RESIST.get()), (Object)new AttributeModifier(uuid, "Spell resistance", spellResistanceWizardSamurai, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (spellPowerWizardSamurai != 0.0 && this == WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.SPELL_POWER.get()), (Object)new AttributeModifier(uuid, "Spell Power", spellPowerWizardSamurai, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (spellCooldownWizardSamurai != 0.0 && this == WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.COOLDOWN_REDUCTION.get()), (Object)new AttributeModifier(uuid, "Cooldown Reduction", spellCooldownWizardSamurai, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (ManaIgnisWizardSamurai != 0.0 && this == IGNIS_WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.MAX_MANA.get()), (Object)new AttributeModifier(uuid, "Ignis Max Mana", ManaIgnisWizardSamurai, AttributeModifier.Operation.ADDITION));
        }
        if (spellResistanceIgnisWizardSamurai != 0.0 && this == IGNIS_WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.SPELL_RESIST.get()), (Object)new AttributeModifier(uuid, "Ignis Spell Resistance", spellResistanceIgnisWizardSamurai, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (spellPowerIgnisWizardSamurai != 0.0 && this == IGNIS_WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.SPELL_POWER.get()), (Object)new AttributeModifier(uuid, "Ignis Spell Power", spellPowerIgnisWizardSamurai, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (ManaSculkWizardSamurai != 0.0 && this == SCULK_WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.MAX_MANA.get()), (Object)new AttributeModifier(uuid, "Sculk Max Mana", ManaSculkWizardSamurai, AttributeModifier.Operation.ADDITION));
        }
        if (spellEldritchWizardSamurai != 0.0 && this == SCULK_WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.ELDRITCH_SPELL_POWER.get()), (Object)new AttributeModifier(uuid, "Sculk Eldrich Spell Power", spellEldritchWizardSamurai, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (spellResistanceSculkWizardSamurai != 0.0 && this == SCULK_WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.SPELL_RESIST.get()), (Object)new AttributeModifier(uuid, "Sculk Power Resistance", spellResistanceSculkWizardSamurai, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (ManaAmethystWizardSamurai != 0.0 && this == AMETHYST_WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.MAX_MANA.get()), (Object)new AttributeModifier(uuid, "Amethyst Max Mana", ManaAmethystWizardSamurai, AttributeModifier.Operation.ADDITION));
        }
        if (ManaRegenAmethystWizardSamurai != 0.0 && this == AMETHYST_WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.MANA_REGEN.get()), (Object)new AttributeModifier(uuid, "Amethyst Mana regen", ManaRegenAmethystWizardSamurai, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (spellCooldownAmethystWizardSamurai != 0.0 && this == AMETHYST_WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.COOLDOWN_REDUCTION.get()), (Object)new AttributeModifier(uuid, "Amethyst Speed Cooldown Cast", spellCooldownAmethystWizardSamurai, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (castSpeedAmethystWizardSamurai != 0.0 && this == AMETHYST_WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.CAST_TIME_REDUCTION.get()), (Object)new AttributeModifier(uuid, "Amethyst Speed Cast", castSpeedAmethystWizardSamurai, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (spellResistanceAmethystWizardSamurai != 0.0 && this == AMETHYST_WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.SPELL_RESIST.get()), (Object)new AttributeModifier(uuid, "Amethyst Spell Resistance", spellResistanceAmethystWizardSamurai, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (CrimsonWizardSamuraiArmorMana != 0.0 && this == CRIMSON_WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.MAX_MANA.get()), (Object)new AttributeModifier(uuid, "Crimson Max Mana", CrimsonWizardSamuraiArmorMana, AttributeModifier.Operation.ADDITION));
        }
        if (CrimsonWizardSamuraiBloodSpellPower != 0.0 && this == CRIMSON_WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.BLOOD_SPELL_POWER.get()), (Object)new AttributeModifier(uuid, "Crimson Eldrich Spell Power", CrimsonWizardSamuraiBloodSpellPower, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (CrimsonWizardSamuraiBloodMagicResistance != 0.0 && this == CRIMSON_WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.BLOOD_MAGIC_RESIST.get()), (Object)new AttributeModifier(uuid, "Crimson Power Resistance", CrimsonWizardSamuraiBloodMagicResistance, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (CrimsonWizardSamuraiSpellResistance != 0.0 && this == CRIMSON_WIZARD_SAMURAI) {
            builder.put((Object)((Attribute)AttributeRegistry.SPELL_RESIST.get()), (Object)new AttributeModifier(uuid, "Crimson Power Resistance", CrimsonWizardSamuraiSpellResistance, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        return builder.build();
    }

    public static EnumMap<ArmorItem.Type, Integer> makeArmorMap(int helmet, int chestplate, int leggings, int boots) {
        return (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), p_266655_ -> {
            p_266655_.put(ArmorItem.Type.BOOTS, boots);
            p_266655_.put(ArmorItem.Type.LEGGINGS, leggings);
            p_266655_.put(ArmorItem.Type.CHESTPLATE, chestplate);
            p_266655_.put(ArmorItem.Type.HELMET, helmet);
        });
    }

    public int getDurabilityForSlot(EquipmentSlot pSlot) {
        return HEALTH_PER_SLOT[pSlot.m_20749_()] * this.durabilityMultiplier;
    }

    public int m_266425_(ArmorItem.Type pType) {
        return HEALTH_FUNCTION_FOR_TYPE.get(pType) * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return -1;
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.m_13971_();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
        ARMOR_ATTRIBUTE_UUID_PER_SLOT = new UUID[]{UUID.fromString("3FD31C99-73DC-4388-A033-B961E59619F6"), UUID.fromString("B05AF2C0-5862-4CE6-860A-522C11E1571A"), UUID.fromString("8AAC342F-4CB0-4593-A643-75A433379905"), UUID.fromString("E095B728-8903-426A-9398-3956E25B3A6D")};
        HEALTH_FUNCTION_FOR_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), p_266653_ -> {
            p_266653_.put(ArmorItem.Type.BOOTS, 13);
            p_266653_.put(ArmorItem.Type.LEGGINGS, 15);
            p_266653_.put(ArmorItem.Type.CHESTPLATE, 16);
            p_266653_.put(ArmorItem.Type.HELMET, 11);
        });
    }
}

