/*
 * Decompiled with CFR 0.152.
 */
package ua.archijk.wizard_samurai.crafting.init.registry;

import java.util.function.Supplier;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import ua.archijk.wizard_samurai.crafting.common.crafting.recipe.ShapedTableCraftingRecipe;
import ua.archijk.wizard_samurai.crafting.common.crafting.recipe.ShapelessTableCraftingRecipe;
import ua.archijk.wizard_samurai.crafting.common.crafting.recipe.WizardSamuraiSmithingRecipe;

@Mod.EventBusSubscriber
public class ModRecipeSerializers {
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"wizard_samurai");
    public static RegistryObject<RecipeSerializer<?>> SHAPED_CRAFT_SERIALIZER = ModRecipeSerializers.serializer("shaped_table", ShapedTableCraftingRecipe.Serializer::new);
    public static RegistryObject<RecipeSerializer<?>> SHAPELESS_CRAFT_SERIALIZER = ModRecipeSerializers.serializer("shapeless_table", ShapelessTableCraftingRecipe.Serializer::new);
    public static RegistryObject<RecipeSerializer<?>> WIZARD_SAMURAI_SMITHING_SERIALIZER = ModRecipeSerializers.serializer("wizard_samurai_smithing", WizardSamuraiSmithingRecipe.Serializer::new);

    public static RegistryObject<RecipeSerializer<?>> serializer(String name, Supplier<RecipeSerializer<?>> serializer) {
        return SERIALIZERS.register(name, serializer);
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.RECIPE_SERIALIZERS)) {
            // empty if block
        }
    }
}

