/*
 * Decompiled with CFR 0.152.
 */
package ua.archijk.wizard_samurai.crafting.init.data.provider.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import ua.archijk.wizard_samurai.crafting.init.registry.ModRecipeSerializers;

public class ModWizardSamuraiSmithingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final Ingredient template;
    private final Ingredient base;
    private final Ingredient additions;
    private final Item result;
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();

    public ModWizardSamuraiSmithingRecipeBuilder(Ingredient pTemplate, Ingredient pBase, Ingredient pAddition, RecipeCategory pCategory, Item pResult) {
        this.category = pCategory;
        this.template = pTemplate;
        this.base = pBase;
        this.additions = pAddition;
        this.result = pResult;
    }

    public static ModWizardSamuraiSmithingRecipeBuilder smithing(Ingredient pTemplate, Ingredient pBase, Ingredient pAddition, RecipeCategory pCategory, Item pResult) {
        return new ModWizardSamuraiSmithingRecipeBuilder(pTemplate, pBase, pAddition, pCategory, pResult);
    }

    @NotNull
    public RecipeBuilder m_126132_(@NotNull String pCriterionName, @NotNull CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    @NotNull
    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        return this;
    }

    @NotNull
    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> pRecipeConsumer, @NotNull ResourceLocation pLocation) {
        this.ensureValid(pLocation);
        this.advancement.m_138396_(RecipeBuilder.f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pLocation)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pLocation)).m_138360_(RequirementsStrategy.f_15979_);
        pRecipeConsumer.accept(new Result(pLocation, this.template, this.base, this.additions, this.result, this.advancement, pLocation.m_246208_("recipes/" + this.category.m_247710_() + "/")));
    }

    private void ensureValid(ResourceLocation pLocation) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(pLocation));
        }
    }

    public record Result(ResourceLocation id, Ingredient template, Ingredient base, Ingredient additions, Item result, Advancement.Builder advancement, ResourceLocation advancementId) implements FinishedRecipe
    {
        public void m_7917_(JsonObject pJson) {
            pJson.add("template", this.template.m_43942_());
            pJson.add("base", this.base.m_43942_());
            pJson.add("addition", this.additions.m_43942_());
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            pJson.add("result", (JsonElement)jsonobject);
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeSerializers.WIZARD_SAMURAI_SMITHING_SERIALIZER.get();
        }

        @NotNull
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

