/*
 * Decompiled with CFR 0.152.
 */
package ua.archijk.wizard_samurai.crafting.init.data.provider.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import ua.archijk.wizard_samurai.crafting.init.registry.ModRecipeSerializers;

public class ModShapelessRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final Item result;
    private final int count;
    private final int tier;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;

    public ModShapelessRecipeBuilder(RecipeCategory p_250837_, @NotNull ItemLike p_251897_, int p_252227_, int tier) {
        this.category = p_250837_;
        this.result = p_251897_.m_5456_();
        this.count = p_252227_;
        this.tier = tier;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static ModShapelessRecipeBuilder shapeless(RecipeCategory p_250714_, ItemLike p_249659_) {
        return new ModShapelessRecipeBuilder(p_250714_, p_249659_, 1, 4);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static ModShapelessRecipeBuilder shapeless(RecipeCategory p_252339_, ItemLike p_250836_, int p_249928_, int tier) {
        return new ModShapelessRecipeBuilder(p_252339_, p_250836_, p_249928_, tier);
    }

    public ModShapelessRecipeBuilder requires(TagKey<Item> p_206420_) {
        return this.requires(Ingredient.m_204132_(p_206420_));
    }

    public ModShapelessRecipeBuilder requires(ItemLike p_126210_) {
        return this.requires(p_126210_, 1);
    }

    public ModShapelessRecipeBuilder requires(ItemLike p_126212_, int p_126213_) {
        for (int i = 0; i < p_126213_; ++i) {
            this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_126212_}));
        }
        return this;
    }

    public ModShapelessRecipeBuilder requires(Ingredient p_126185_) {
        return this.requires(p_126185_, 1);
    }

    public ModShapelessRecipeBuilder requires(Ingredient p_126187_, int p_126188_) {
        for (int i = 0; i < p_126188_; ++i) {
            this.ingredients.add(p_126187_);
        }
        return this;
    }

    @NotNull
    public ModShapelessRecipeBuilder unlockedBy(@NotNull String p_126197_, @NotNull CriterionTriggerInstance p_126198_) {
        this.advancement.m_138386_(p_126197_, p_126198_);
        return this;
    }

    @NotNull
    public ModShapelessRecipeBuilder group(@Nullable String p_126195_) {
        this.group = p_126195_;
        return this;
    }

    @NotNull
    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(@NotNull Consumer<FinishedRecipe> p_126205_, @NotNull ResourceLocation p_126206_) {
        this.ensureValid(p_126206_);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)p_126206_)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)p_126206_)).m_138360_(RequirementsStrategy.f_15979_);
        p_126205_.accept((FinishedRecipe)new Result(p_126206_, this.result, this.count, this.tier, this.group == null ? "" : this.group, ModShapelessRecipeBuilder.m_245179_((RecipeCategory)this.category), this.ingredients, this.advancement, p_126206_.m_246208_("recipes/" + this.category.m_247710_() + "/")));
    }

    private void ensureValid(ResourceLocation p_126208_) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(p_126208_));
        }
    }

    public static class Result
    extends CraftingRecipeBuilder.CraftingResult {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final int tier;
        private final String group;
        private final List<Ingredient> ingredients;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation p_249007_, Item p_248667_, int count, int tier, String p_248592_, CraftingBookCategory p_249485_, List<Ingredient> p_252312_, Advancement.Builder p_249909_, ResourceLocation p_249109_) {
            super(p_249485_);
            this.id = p_249007_;
            this.result = p_248667_;
            this.count = count;
            this.tier = tier;
            this.group = p_248592_;
            this.ingredients = p_252312_;
            this.advancement = p_249909_;
            this.advancementId = p_249109_;
        }

        public void m_7917_(@NotNull JsonObject p_126230_) {
            super.m_7917_(p_126230_);
            if (!this.group.isEmpty()) {
                p_126230_.addProperty("group", this.group);
            }
            p_126230_.addProperty("tier", (Number)this.tier);
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.m_43942_());
            }
            p_126230_.add("ingredients", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.result)).toString());
            if (this.count > 1) {
                jsonobject.addProperty("count", (Number)this.count);
            }
            p_126230_.add("result", (JsonElement)jsonobject);
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeSerializers.SHAPELESS_CRAFT_SERIALIZER.get();
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

