/*
 * Decompiled with CFR 0.152.
 */
package ua.archijk.wizard_samurai.crafting.init.compat.jei.category.tables;

import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import ua.archijk.wizard_samurai.crafting.common.crafting.recipe.BaseTableCraftingRecipe;
import ua.archijk.wizard_samurai.crafting.common.crafting.recipe.ShapedTableCraftingRecipe;
import ua.archijk.wizard_samurai.crafting.common.crafting.recipe.ShapelessTableCraftingRecipe;
import ua.archijk.wizard_samurai.crafting.init.registry.ModBlocks;
import ua.archijk.wizard_samurai.crafting.util.lang.Localizable;

public class WizardSamuraiCraftingTableCategory
implements IRecipeCategory<BaseTableCraftingRecipe> {
    public static final RecipeType<BaseTableCraftingRecipe> RECIPE_TYPE = RecipeType.create((String)"wizard_samurai", (String)"wizard_samurai_craft", BaseTableCraftingRecipe.class);
    private static final ResourceLocation TEXTURE = new ResourceLocation("wizard_samurai", "textures/gui/jei/crafting_table/wizard_samurai_crafting_table_jei.png");
    private final IDrawable background;
    private final IDrawable icon;

    public WizardSamuraiCraftingTableCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 158, 101);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.wizard_samurai_crafting_table.get()));
    }

    @NotNull
    public RecipeType<BaseTableCraftingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Localizable.of("jei.category.wizard_samurai.wizard_samurai_crafting_table").build();
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, BaseTableCraftingRecipe recipe, @NotNull IFocusGroup focuses) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        assert (level != null);
        NonNullList inputs = recipe.m_7527_();
        ItemStack output = recipe.m_8043_(level.m_9598_());
        if (recipe instanceof ShapedTableCraftingRecipe) {
            ShapedTableCraftingRecipe shaped = (ShapedTableCraftingRecipe)recipe;
            int stackIndex = 0;
            int heightOffset = Math.floorDiv(5 - shaped.getHeight(), 2);
            int widthOffset = Math.floorDiv(5 - shaped.getWidth(), 2);
            for (int i = heightOffset; i < shaped.getHeight() + heightOffset; ++i) {
                for (int j = widthOffset; j < shaped.getWidth() + widthOffset; ++j) {
                    builder.addSlot(RecipeIngredientRole.INPUT, j * 18 + 5, i * 18 + 5).addIngredients((Ingredient)inputs.get(stackIndex));
                    ++stackIndex;
                }
            }
            builder.addSlot(RecipeIngredientRole.OUTPUT, 133, 40).addItemStack(output);
        } else if (recipe instanceof ShapelessTableCraftingRecipe) {
            this.shapelessRecipe(builder, (NonNullList<Ingredient>)inputs);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 133, 40).addItemStack(output);
        }
        builder.moveRecipeTransferButton(134, 85);
    }

    private void shapelessRecipe(@NotNull IRecipeLayoutBuilder builder, NonNullList<Ingredient> inputs) {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                int index = j + i * 5;
                if (index >= inputs.size()) continue;
                builder.addSlot(RecipeIngredientRole.INPUT, j * 18 + 2, i * 18 + 2).addIngredients((Ingredient)inputs.get(index));
            }
        }
        builder.setShapeless(99, 85);
    }

    @NotNull
    public List<Component> getTooltipStrings(@NotNull BaseTableCraftingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        boolean shapeless = recipe instanceof ShapelessTableCraftingRecipe;
        int sX = (shapeless ? 340 : 306) / 2;
        int sY = 100;
        if (shapeless && mouseX > (double)(sX + 10) && mouseX < (double)(sX + 20) && mouseY > (double)(sY - 1) && mouseY < (double)(sY + 8)) {
            return Collections.singletonList(Localizable.of("jei.tooltip.shapeless.recipe").build());
        }
        return Collections.emptyList();
    }
}

