/*
 * Decompiled with CFR 0.152.
 */
package ua.archijk.wizard_samurai.crafting.init.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import ua.archijk.wizard_samurai.crafting.client.screen.WizardSamuraiSmithingScreen;
import ua.archijk.wizard_samurai.crafting.client.screen.craft.WizardSamuraiAccessoryCraftScreen;
import ua.archijk.wizard_samurai.crafting.client.screen.craft.WizardSamuraiCraftScreen;
import ua.archijk.wizard_samurai.crafting.common.menu.ModCraftMenu;
import ua.archijk.wizard_samurai.crafting.common.menu.WizardSamuraiSmithingMenu;
import ua.archijk.wizard_samurai.crafting.init.compat.jei.category.WizardSamuraiSmithingRecipeCategory;
import ua.archijk.wizard_samurai.crafting.init.compat.jei.category.tables.WizardSamuraiAccessoryCraftingTableCategory;
import ua.archijk.wizard_samurai.crafting.init.compat.jei.category.tables.WizardSamuraiCraftingTableCategory;
import ua.archijk.wizard_samurai.crafting.init.registry.ModBlocks;
import ua.archijk.wizard_samurai.crafting.init.registry.ModMenus;
import ua.archijk.wizard_samurai.crafting.init.registry.ModRecipeTypes;

@JeiPlugin
public class JeiCompat
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("wizard_samurai", "jei_plugin");

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new WizardSamuraiAccessoryCraftingTableCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new WizardSamuraiCraftingTableCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new WizardSamuraiSmithingRecipeCategory(helper)});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            RecipeManager manager = world.m_7465_();
            registration.addRecipes(WizardSamuraiSmithingRecipeCategory.RECIPE_TYPE, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.WIZARD_SAMURAI_SMITHING_RECIPE.get()));
            Map<Integer, List> recipes = Stream.of(1, 2, 3, 4).collect(Collectors.toMap(tier -> tier, tier -> manager.m_44054_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.CRAFTING_TABLE_RECIPE.get()).values().stream().filter(recipe -> recipe.hasRequiredTier() ? tier.intValue() == recipe.getTier() : tier >= recipe.getTier()).toList()));
            registration.addRecipes(WizardSamuraiAccessoryCraftingTableCategory.RECIPE_TYPE, (List)recipes.getOrDefault(1, new ArrayList()));
            registration.addRecipes(WizardSamuraiCraftingTableCategory.RECIPE_TYPE, (List)recipes.getOrDefault(2, new ArrayList()));
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.wizard_samurai_accessory_crafting_table.get()), new RecipeType[]{WizardSamuraiAccessoryCraftingTableCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.wizard_samurai_crafting_table.get()), new RecipeType[]{WizardSamuraiCraftingTableCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.wizard_samurai_smithing_table.get()), new RecipeType[]{WizardSamuraiSmithingRecipeCategory.RECIPE_TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(ModCraftMenu.class, (MenuType)ModMenus.wizard_samurai_accessory_crafting_tile_table.get(), WizardSamuraiAccessoryCraftingTableCategory.RECIPE_TYPE, 1, 9, 10, 36);
        registration.addRecipeTransferHandler(ModCraftMenu.class, (MenuType)ModMenus.wizard_samurai_crafting_tile_table.get(), WizardSamuraiCraftingTableCategory.RECIPE_TYPE, 1, 25, 26, 36);
        registration.addRecipeTransferHandler(WizardSamuraiSmithingMenu.class, (MenuType)ModMenus.wizard_samurai_smithing_table.get(), WizardSamuraiSmithingRecipeCategory.RECIPE_TYPE, 1, 5, 6, 36);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(WizardSamuraiAccessoryCraftScreen.class, 90, 40, 22, 12, new RecipeType[]{WizardSamuraiAccessoryCraftingTableCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(WizardSamuraiCraftScreen.class, 100, 40, 22, 12, new RecipeType[]{WizardSamuraiCraftingTableCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(WizardSamuraiSmithingScreen.class, 86, 27, 22, 12, new RecipeType[]{WizardSamuraiSmithingRecipeCategory.RECIPE_TYPE});
    }

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registration) {
    }
}

