/*
 * Decompiled with CFR 0.152.
 */
package ua.archijk.wizard_samurai.crafting.init.compat.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;
import ua.archijk.wizard_samurai.crafting.common.crafting.recipe.BaseTableCraftingRecipe;
import ua.archijk.wizard_samurai.crafting.common.crafting.recipe.ShapedTableCraftingRecipe;
import ua.archijk.wizard_samurai.crafting.common.crafting.recipe.ShapelessTableCraftingRecipe;
import ua.archijk.wizard_samurai.crafting.init.registry.ModRecipeTypes;

@ZenCodeType.Name(value="mods.wizard_samurai.CraftingTable")
@ZenRegister
public class CraftingTable
implements IRecipeManager<BaseTableCraftingRecipe> {
    private static final CraftingTable INSTANCE = new CraftingTable();

    @ZenCodeType.Method
    public static void addShaped(String name, int tier, IItemStack output, IIngredient[][] inputs) {
        ResourceLocation id = CraftTweakerConstants.rl((String)INSTANCE.fixRecipeName(name));
        if (tier > 4 || tier < 0) {
            tier = 0;
            CraftTweakerAPI.getLogger((String)"wizard_samurai").error("Unable to assign a tier to the Table Recipe for stack " + output.getCommandString() + ". Tier cannot be greater than 4 or less than 0.");
        }
        int height = inputs.length;
        int width = 0;
        for (IIngredient[] row : inputs) {
            if (width >= row.length) continue;
            width = row.length;
        }
        NonNullList ingredients = NonNullList.m_122780_((int)(height * width), (Object)Ingredient.f_43901_);
        for (int a = 0; a < height; ++a) {
            for (int b = 0; b < inputs[a].length; ++b) {
                IIngredient iing = inputs[a][b];
                Ingredient ing = iing.asVanillaIngredient();
                int i = a * width + b;
                ingredients.set(i, (Object)ing);
            }
        }
        ShapedTableCraftingRecipe recipe = new ShapedTableCraftingRecipe(id, width, height, (NonNullList<Ingredient>)ingredients, output.getInternal(), tier);
        recipe.setTransformers((x, y, stack) -> inputs[y][x].getRemainingItem((IItemStack)new MCItemStack(stack)).getInternal());
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)INSTANCE, (Recipe)recipe));
    }

    @ZenCodeType.Method
    public static void addShapeless(String name, IItemStack output, IIngredient[] inputs) {
        CraftingTable.addShapeless(name, 0, output, inputs);
    }

    @ZenCodeType.Method
    public static void addShapeless(String name, int tier, IItemStack output, IIngredient[] inputs) {
        ResourceLocation id = CraftTweakerConstants.rl((String)INSTANCE.fixRecipeName(name));
        if (tier > 4 || tier < 0) {
            tier = 0;
            CraftTweakerAPI.getLogger((String)"wizard_samurai").error("Unable to assign a tier to the Table Recipe for stack " + output.getCommandString() + ". Tier cannot be greater than 4 or less than 0.");
        }
        ShapelessTableCraftingRecipe recipe = new ShapelessTableCraftingRecipe(id, CraftingTable.toIngredientsList(inputs), output.getInternal(), tier);
        recipe.setTransformers((slot, stack) -> inputs[slot].getRemainingItem((IItemStack)new MCItemStack(stack)).getInternal());
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)INSTANCE, (Recipe)recipe));
    }

    @ZenCodeType.Method
    public static void remove(IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)INSTANCE, recipe -> recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_150930_(stack.getInternal().m_41720_())));
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... ingredients) {
        return Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::m_122779_));
    }

    public RecipeType<BaseTableCraftingRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.CRAFTING_TABLE_RECIPE.get();
    }
}

