/*
 * Decompiled with CFR 0.152.
 */
package ua.archijk.wizard_samurai.crafting.init.compat;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import ua.archijk.wizard_samurai.crafting.common.block.craft.ModCraftTableBlock;
import ua.archijk.wizard_samurai.crafting.common.block.smith.WizardSamuraiSmithingTableBlock;
import ua.archijk.wizard_samurai.crafting.common.crafting.recipe.BaseTableCraftingRecipe;
import ua.archijk.wizard_samurai.crafting.common.crafting.recipe.WizardSamuraiSmithingRecipe;
import ua.archijk.wizard_samurai.crafting.common.tile.ModCraftTile;
import ua.archijk.wizard_samurai.crafting.init.registry.ModRecipeTypes;
import ua.archijk.wizard_samurai.crafting.init.registry.ModTooltips;

@WailaPlugin
public class JadeCompat
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IBlockComponentProvider)CraftingComponentProvider.INSTANCE, ModCraftTableBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)WizardSamuraiSmithingComponentProvider.INSTANCE, WizardSamuraiSmithingTableBlock.class);
    }

    public static final class CraftingComponentProvider
    extends Enum<CraftingComponentProvider>
    implements IBlockComponentProvider {
        public static final /* enum */ CraftingComponentProvider INSTANCE = new CraftingComponentProvider();
        private static final /* synthetic */ CraftingComponentProvider[] $VALUES;

        public static CraftingComponentProvider[] values() {
            return (CraftingComponentProvider[])$VALUES.clone();
        }

        public static CraftingComponentProvider valueOf(String name) {
            return Enum.valueOf(CraftingComponentProvider.class, name);
        }

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            assert (level != null);
            ModCraftTile compressor = (ModCraftTile)accessor.getBlockEntity();
            Optional recipe = level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.CRAFTING_TABLE_RECIPE.get(), compressor.getInventory().toIInventory(), (Level)level);
            if (recipe.isPresent()) {
                ItemStack output = ((BaseTableCraftingRecipe)recipe.get()).m_8043_(level.m_9598_());
                tooltip.add((Component)ModTooltips.CRAFTING.args(output.m_41613_(), output.m_41786_()).build());
            }
        }

        public ResourceLocation getUid() {
            return new ResourceLocation("wizard_samurai", "crafting_table");
        }

        private static /* synthetic */ CraftingComponentProvider[] $values() {
            return new CraftingComponentProvider[]{INSTANCE};
        }

        static {
            $VALUES = CraftingComponentProvider.$values();
        }
    }

    public static final class WizardSamuraiSmithingComponentProvider
    extends Enum<WizardSamuraiSmithingComponentProvider>
    implements IBlockComponentProvider {
        public static final /* enum */ WizardSamuraiSmithingComponentProvider INSTANCE = new WizardSamuraiSmithingComponentProvider();
        private static final /* synthetic */ WizardSamuraiSmithingComponentProvider[] $VALUES;

        public static WizardSamuraiSmithingComponentProvider[] values() {
            return (WizardSamuraiSmithingComponentProvider[])$VALUES.clone();
        }

        public static WizardSamuraiSmithingComponentProvider valueOf(String name) {
            return Enum.valueOf(WizardSamuraiSmithingComponentProvider.class, name);
        }

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            assert (level != null);
            List recipes = level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.WIZARD_SAMURAI_SMITHING_RECIPE.get());
            if (!recipes.isEmpty()) {
                WizardSamuraiSmithingRecipe recipe = (WizardSamuraiSmithingRecipe)recipes.get(0);
                ItemStack output = recipe.m_8043_(level.m_9598_());
                tooltip.add((Component)ModTooltips.SMITHING.args(output.m_41613_(), output.m_41786_()).build());
            }
        }

        public ResourceLocation getUid() {
            return new ResourceLocation("wizard_samurai", "wizard_samurai_smithing");
        }

        private static /* synthetic */ WizardSamuraiSmithingComponentProvider[] $values() {
            return new WizardSamuraiSmithingComponentProvider[]{INSTANCE};
        }

        static {
            $VALUES = WizardSamuraiSmithingComponentProvider.$values();
        }
    }
}

