/*
 * Decompiled with CFR 0.152.
 */
package ua.archijk.wizard_samurai.crafting.common.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.archijk.wizard_samurai.crafting.api.common.tile.BaseInventoryTileEntity;
import ua.archijk.wizard_samurai.crafting.api.common.wrapper.ItemStackWrapper;
import ua.archijk.wizard_samurai.crafting.common.menu.ModCraftMenu;
import ua.archijk.wizard_samurai.crafting.init.registry.ModBlocks;
import ua.archijk.wizard_samurai.crafting.init.registry.ModCraftTier;
import ua.archijk.wizard_samurai.crafting.init.registry.ModTileEntities;
import ua.archijk.wizard_samurai.crafting.util.lang.Localizable;

public class ModCraftTile
extends BaseInventoryTileEntity {
    private final ItemStackWrapper inventory;
    private ModCraftTier tier;

    public ModCraftTile(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModTileEntities.mod_craft_tile.get(), pos, blockState);
        if (blockState.m_60713_((Block)ModBlocks.wizard_samurai_crafting_table.get())) {
            this.tier = ModCraftTier.WIZARD_SAMURAI;
        } else if (blockState.m_60713_((Block)ModBlocks.wizard_samurai_accessory_crafting_table.get())) {
            this.tier = ModCraftTier.WIZARD_SAMURAI_ACCESSORY;
        }
        this.inventory = new ItemStackWrapper(this.tier.size * this.tier.size, this::setChangedAndDispatch);
    }

    @Override
    @NotNull
    public ItemStackWrapper getInventory() {
        return this.inventory;
    }

    @NotNull
    public Component m_5446_() {
        return Localizable.of("container." + this.tier.name).build();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pInventory) {
        switch (this.tier) {
            case WIZARD_SAMURAI: {
                return ModCraftMenu.wizard_samurai(pContainerId, pInventory, this.inventory, this.m_58899_());
            }
            case WIZARD_SAMURAI_ACCESSORY: {
                return ModCraftMenu.accessory_wizard_samurai(pContainerId, pInventory, this.inventory, this.m_58899_());
            }
        }
        return ModCraftMenu.wizard_samurai(pContainerId, pInventory, this.inventory, this.m_58899_());
    }
}

