/*
 * Decompiled with CFR 0.152.
 */
package ua.archijk.wizard_samurai.crafting.common.menu;

import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.archijk.wizard_samurai.crafting.common.crafting.recipe.WizardSamuraiSmithingRecipe;
import ua.archijk.wizard_samurai.crafting.init.registry.ModMenus;
import ua.archijk.wizard_samurai.crafting.init.registry.ModRecipeTypes;

public class WizardSamuraiSmithingMenu
extends ItemCombinerMenu {
    @Nullable
    private SmithingRecipe selectedRecipe;
    private final Level level;
    private final List<WizardSamuraiSmithingRecipe> recipes;

    public WizardSamuraiSmithingMenu(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(id, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public WizardSamuraiSmithingMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess access) {
        super((MenuType)ModMenus.wizard_samurai_smithing_table.get(), pContainerId, pPlayerInventory, access);
        this.level = pPlayerInventory.f_35978_.m_9236_();
        this.recipes = this.level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.WIZARD_SAMURAI_SMITHING_RECIPE.get());
    }

    protected boolean m_6560_(@NotNull Player pPlayer, boolean pHasStack) {
        return this.selectedRecipe != null && this.selectedRecipe.m_5818_(this.f_39769_, this.level);
    }

    protected void m_142365_(@NotNull Player pPlayer, @NotNull ItemStack pStack) {
        pStack.m_41678_(pPlayer.m_9236_(), pPlayer, pStack.m_41613_());
        this.f_39768_.m_58395_(pPlayer, this.getRelevantItems());
        this.shrinkStackInSlot(0);
        this.shrinkStackInSlot(1);
        this.shrinkStackInSlot(2);
        this.shrinkStackInSlot(3);
        this.shrinkStackInSlot(4);
        this.f_39770_.m_39292_((level, pos) -> level.m_46796_(1044, pos, 0));
    }

    protected boolean m_8039_(@NotNull BlockState pState) {
        return false;
    }

    public boolean m_6875_(@NotNull Player pPlayer) {
        return true;
    }

    public void m_6640_() {
        List list = this.level.m_7465_().m_44056_((RecipeType)ModRecipeTypes.WIZARD_SAMURAI_SMITHING_RECIPE.get(), this.f_39769_, this.level);
        if (list.isEmpty()) {
            this.f_39768_.m_6836_(0, ItemStack.f_41583_);
        } else {
            WizardSamuraiSmithingRecipe smithingrecipe = (WizardSamuraiSmithingRecipe)list.get(0);
            ItemStack itemstack = smithingrecipe.m_5874_(this.f_39769_, this.level.m_9598_());
            if (itemstack.m_246617_(this.level.m_246046_())) {
                this.selectedRecipe = smithingrecipe;
                this.f_39768_.m_6029_((Recipe)smithingrecipe);
                this.f_39768_.m_6836_(0, itemstack);
            }
        }
    }

    @NotNull
    protected ItemCombinerMenuSlotDefinition m_266183_() {
        return ItemCombinerMenuSlotDefinition.m_266303_().m_266197_(0, 31, 35, stack -> this.recipes.stream().anyMatch(recipe -> recipe.m_266166_((ItemStack)stack))).m_266197_(1, 49, 35, stack -> this.recipes.stream().anyMatch(recipe -> recipe.m_266343_((ItemStack)stack))).m_266197_(2, 67, 35, stack -> this.recipes.stream().anyMatch(recipe -> recipe.m_266253_((ItemStack)stack))).m_266197_(3, 49, 17, stack -> this.recipes.stream().anyMatch(recipe -> recipe.m_266253_((ItemStack)stack))).m_266197_(4, 49, 53, stack -> this.recipes.stream().anyMatch(recipe -> recipe.m_266253_((ItemStack)stack))).m_266198_(5, 121, 35).m_266441_();
    }

    private List<ItemStack> getRelevantItems() {
        return List.of(this.f_39769_.m_8020_(0), this.f_39769_.m_8020_(1), this.f_39769_.m_8020_(2), this.f_39769_.m_8020_(3), this.f_39769_.m_8020_(4));
    }

    private void shrinkStackInSlot(int pIndex) {
        ItemStack itemstack = this.f_39769_.m_8020_(pIndex);
        if (!itemstack.m_41619_()) {
            itemstack.m_41774_(1);
            this.f_39769_.m_6836_(pIndex, itemstack);
        }
    }

    public int m_266159_(@NotNull ItemStack pStack) {
        return this.recipes.stream().map(smithingRecipe -> WizardSamuraiSmithingMenu.findSlotMatchingIngredient(smithingRecipe, pStack)).filter(Optional::isPresent).findFirst().orElse(Optional.of(List.of(Integer.valueOf(0)))).get().get(0);
    }

    private static Optional<List<Integer>> findSlotMatchingIngredient(SmithingRecipe pRecipe, ItemStack pStack) {
        if (pRecipe.m_266166_(pStack)) {
            return Optional.of(List.of(Integer.valueOf(0)));
        }
        if (pRecipe.m_266343_(pStack)) {
            return Optional.of(List.of(Integer.valueOf(1)));
        }
        return pRecipe.m_266253_(pStack) ? Optional.of(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4))) : Optional.empty();
    }

    public boolean m_5882_(@NotNull ItemStack pStack, Slot pSlot) {
        return pSlot.f_40218_ != this.f_39768_ && super.m_5882_(pStack, pSlot);
    }

    public boolean m_5861_(@NotNull ItemStack pStack) {
        return this.recipes.stream().map(smithingRecipe -> WizardSamuraiSmithingMenu.findSlotMatchingIngredient(smithingRecipe, pStack)).anyMatch(Optional::isPresent);
    }
}

