/*
 * Decompiled with CFR 0.152.
 */
package ua.archijk.wizard_samurai.crafting.common.menu;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import ua.archijk.wizard_samurai.crafting.api.common.menu.BaseMenu;
import ua.archijk.wizard_samurai.crafting.api.common.wrapper.ItemStackWrapper;
import ua.archijk.wizard_samurai.crafting.common.container.ModCraftContainer;
import ua.archijk.wizard_samurai.crafting.common.container.slot.ModCraftResultSlot;
import ua.archijk.wizard_samurai.crafting.common.crafting.recipe.BaseTableCraftingRecipe;
import ua.archijk.wizard_samurai.crafting.init.registry.ModCraftTier;
import ua.archijk.wizard_samurai.crafting.init.registry.ModMenus;
import ua.archijk.wizard_samurai.crafting.init.registry.ModRecipeTypes;

public class ModCraftMenu
extends BaseMenu {
    private final Level world;
    private final Container result;
    private final Player player;
    private final ModCraftTier tier;

    private ModCraftMenu(MenuType<?> type, int id, Inventory playerInventory, FriendlyByteBuf buf, ModCraftTier tier) {
        this(type, id, playerInventory, new ItemStackWrapper(tier.size * tier.size), buf.m_130135_(), tier);
    }

    public ModCraftMenu(MenuType<?> type, int id, Inventory playerInventory, ItemStackWrapper inventory, BlockPos pos, ModCraftTier tier) {
        super(type, id, pos);
        int j;
        int i;
        this.player = playerInventory.f_35978_;
        this.world = playerInventory.f_35978_.m_9236_();
        this.result = new ResultContainer();
        this.tier = tier;
        ModCraftContainer matrix = new ModCraftContainer(this, inventory, tier.size * tier.size);
        this.m_38897_(new ModCraftResultSlot(this.player, this, (CraftingContainer)matrix, this.result, 0, tier.outX, tier.outY));
        for (i = 0; i < tier.size; ++i) {
            for (j = 0; j < tier.size; ++j) {
                this.m_38897_(new Slot((Container)matrix, j + i * tier.size, tier.mainX + j * 18, tier.mainY + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, tier.playerInvX + j * 18, tier.playerInvY + i * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.m_38897_(new Slot((Container)playerInventory, j, tier.hotBarX + j * 18, tier.hotBarY));
        }
        this.m_6199_((Container)matrix);
    }

    public static ModCraftMenu accessory_wizard_samurai(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        return new ModCraftMenu((MenuType)ModMenus.wizard_samurai_accessory_crafting_tile_table.get(), windowId, playerInventory, buf, ModCraftTier.WIZARD_SAMURAI_ACCESSORY);
    }

    public static ModCraftMenu accessory_wizard_samurai(int windowId, Inventory playerInventory, ItemStackWrapper inventory, BlockPos pos) {
        return new ModCraftMenu((MenuType)ModMenus.wizard_samurai_accessory_crafting_tile_table.get(), windowId, playerInventory, inventory, pos, ModCraftTier.WIZARD_SAMURAI_ACCESSORY);
    }

    public static ModCraftMenu wizard_samurai(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        return new ModCraftMenu((MenuType)ModMenus.wizard_samurai_crafting_tile_table.get(), windowId, playerInventory, buf, ModCraftTier.WIZARD_SAMURAI);
    }

    public static ModCraftMenu wizard_samurai(int windowId, Inventory playerInventory, ItemStackWrapper inventory, BlockPos pos) {
        return new ModCraftMenu((MenuType)ModMenus.wizard_samurai_crafting_tile_table.get(), windowId, playerInventory, inventory, pos, ModCraftTier.WIZARD_SAMURAI);
    }

    public void m_6199_(@NotNull Container matrix) {
        Optional recipe = this.world.m_7465_().m_44015_((RecipeType)ModRecipeTypes.CRAFTING_TABLE_RECIPE.get(), matrix, this.world);
        if (recipe.isPresent()) {
            ItemStack result = ((BaseTableCraftingRecipe)recipe.get()).m_5874_(matrix, this.world.m_9598_());
            this.result.m_6836_(0, result);
        } else {
            this.result.m_6836_(0, ItemStack.f_41583_);
        }
        super.m_6199_(matrix);
    }

    @Override
    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int slotNumber) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotNumber);
        int in_slots = this.tier.size * this.tier.size + 1;
        int inv_slots = this.tier.size * this.tier.size + 1 + 36;
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotNumber == 0) {
                if (!this.m_38903_(itemstack1, in_slots, inv_slots, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (slotNumber >= in_slots && slotNumber < inv_slots ? !this.m_38903_(itemstack1, 1, in_slots, false) : !this.m_38903_(itemstack1, in_slots, inv_slots, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }
}

