/*
 * Decompiled with CFR 0.152.
 */
package ua.archijk.wizard_samurai.crafting.common.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;
import ua.archijk.wizard_samurai.crafting.init.registry.ModRecipeSerializers;
import ua.archijk.wizard_samurai.crafting.init.registry.ModRecipeTypes;

public class WizardSamuraiSmithingRecipe
implements SmithingRecipe {
    private final ResourceLocation id;
    public final Ingredient template;
    public final Ingredient base;
    public final Ingredient additions;
    public final ItemStack result;

    public WizardSamuraiSmithingRecipe(ResourceLocation pId, Ingredient pTemplate, Ingredient pBase, Ingredient additions, ItemStack pResult) {
        this.id = pId;
        this.template = pTemplate;
        this.base = pBase;
        this.additions = additions;
        this.result = pResult;
    }

    public boolean m_5818_(Container pContainer, @NotNull Level pLevel) {
        return this.template.test(pContainer.m_8020_(0)) && this.base.test(pContainer.m_8020_(1)) && this.additions.test(pContainer.m_8020_(2)) && this.additions.test(pContainer.m_8020_(3)) && this.additions.test(pContainer.m_8020_(4));
    }

    @NotNull
    public ItemStack m_5874_(Container pContainer, @NotNull RegistryAccess pRegistryAccess) {
        ItemStack itemstack = this.result.m_41777_();
        CompoundTag compoundtag = pContainer.m_8020_(1).m_41783_();
        if (compoundtag != null) {
            itemstack.m_41751_(compoundtag.m_6426_());
        }
        return itemstack;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess pRegistryAccess) {
        return this.result;
    }

    public boolean m_266166_(@NotNull ItemStack pStack) {
        return this.template.test(pStack);
    }

    public boolean m_266343_(@NotNull ItemStack pStack) {
        return this.base.test(pStack);
    }

    public boolean m_266253_(@NotNull ItemStack pStack) {
        return this.additions.test(pStack);
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.WIZARD_SAMURAI_SMITHING_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.WIZARD_SAMURAI_SMITHING_RECIPE.get();
    }

    public boolean m_142505_() {
        return Stream.of(this.template, this.base, this.additions).anyMatch(ForgeHooks::hasNoElements);
    }

    public static class Serializer
    implements RecipeSerializer<WizardSamuraiSmithingRecipe> {
        @NotNull
        public WizardSamuraiSmithingRecipe fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject pSerializedRecipe) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)pSerializedRecipe, (String)"template"));
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)pSerializedRecipe, (String)"base"));
            Ingredient ingredient2 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)pSerializedRecipe, (String)"addition"));
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"result"));
            return new WizardSamuraiSmithingRecipe(pRecipeId, ingredient, ingredient1, ingredient2, itemstack);
        }

        public WizardSamuraiSmithingRecipe fromNetwork(@NotNull ResourceLocation pRecipeId, @NotNull FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient ingredient2 = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack itemstack = pBuffer.m_130267_();
            return new WizardSamuraiSmithingRecipe(pRecipeId, ingredient, ingredient1, ingredient2, itemstack);
        }

        public void toNetwork(@NotNull FriendlyByteBuf pBuffer, WizardSamuraiSmithingRecipe pRecipe) {
            pRecipe.template.m_43923_(pBuffer);
            pRecipe.base.m_43923_(pBuffer);
            pRecipe.additions.m_43923_(pBuffer);
            pBuffer.m_130055_(pRecipe.result);
        }
    }
}

