/*
 * Decompiled with CFR 0.152.
 */
package ua.archijk.wizard_samurai.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.common.ForgeConfigSpec;

public class ArmorConfig {
    public static final ForgeConfigSpec ARMOR_SPEC;
    public static ArmorValues WizardSamuraiArmorValue;
    public static ArmorValues IgnisSamuraiArmorValue;
    public static ArmorValues IgnisWizardSamuraiArmorValue;
    public static ArmorValues SculkWizardSamuraiArmorValue;
    public static ArmorValues AmethystWizardSamuraiArmorValue;
    public static ArmorValues CrimsonWizardSamuraiArmorValue;
    public static ForgeConfigSpec.IntValue WizardSamuraiArmorDurability;
    public static ForgeConfigSpec.IntValue WizardSamuraiArmorEnchantmentValue;
    public static ForgeConfigSpec.DoubleValue WizardSamuraiArmorToughness;
    public static ForgeConfigSpec.DoubleValue WizardSamuraiArmorKnockbackResistance;
    public static ForgeConfigSpec.IntValue WizardSamuraiArmorMana;
    public static ForgeConfigSpec.DoubleValue WizardSamuraiArmorManaRegen;
    public static ForgeConfigSpec.DoubleValue WizardSamuraiArmorCastSpeed;
    public static ForgeConfigSpec.DoubleValue WizardSamuraiArmorSpellResistance;
    public static ForgeConfigSpec.DoubleValue WizardSamuraiArmorSpellPower;
    public static ForgeConfigSpec.DoubleValue WizardSamuraiArmorSpellCooldown;
    public static ForgeConfigSpec.IntValue IgnisSamuraiArmorDurability;
    public static ForgeConfigSpec.IntValue IgnisSamuraiArmorEnchantmentValue;
    public static ForgeConfigSpec.DoubleValue IgnisSamuraiArmorToughness;
    public static ForgeConfigSpec.DoubleValue IgnisSamuraiArmorKnockbackResistance;
    public static ForgeConfigSpec.IntValue IgnisWizardSamuraiArmorDurability;
    public static ForgeConfigSpec.IntValue IgnisWizardSamuraiArmorEnchantmentValue;
    public static ForgeConfigSpec.DoubleValue IgnisWizardSamuraiArmorToughness;
    public static ForgeConfigSpec.DoubleValue IgnisWizardSamuraiArmorKnockbackResistance;
    public static ForgeConfigSpec.DoubleValue IgnisWizardSamuraiArmorSpellResistance;
    public static ForgeConfigSpec.DoubleValue IgnisWizardSamuraiArmorSpellPower;
    public static ForgeConfigSpec.IntValue IgnisWizardSamuraiArmorMana;
    public static ForgeConfigSpec.IntValue SculkWizardSamuraiArmorDurability;
    public static ForgeConfigSpec.IntValue SculkWizardSamuraiArmorEnchantmentValue;
    public static ForgeConfigSpec.DoubleValue SculkWizardSamuraiArmorToughness;
    public static ForgeConfigSpec.DoubleValue SculkWizardSamuraiArmorKnockbackResistance;
    public static ForgeConfigSpec.DoubleValue SculkWizardSamuraiArmorSpellResistance;
    public static ForgeConfigSpec.IntValue SculkWizardSamuraiArmorMana;
    public static ForgeConfigSpec.DoubleValue SculkWizardSamuraiArmorSpellEldritch;
    public static ForgeConfigSpec.IntValue AmethystWizardSamuraiArmorDurability;
    public static ForgeConfigSpec.IntValue AmethystWizardSamuraiArmorEnchantmentValue;
    public static ForgeConfigSpec.DoubleValue AmethystWizardSamuraiArmorToughness;
    public static ForgeConfigSpec.DoubleValue AmethystWizardSamuraiArmorKnockbackResistance;
    public static ForgeConfigSpec.DoubleValue AmethystWizardSamuraiArmorSpellResistance;
    public static ForgeConfigSpec.IntValue AmethystWizardSamuraiArmorMana;
    public static ForgeConfigSpec.DoubleValue AmethystWizardSamuraiArmorManaRegen;
    public static ForgeConfigSpec.DoubleValue AmethystWizardSamuraiArmorSpellCooldown;
    public static ForgeConfigSpec.DoubleValue AmethystWizardSamuraiArmorCastSpeed;
    public static ForgeConfigSpec.IntValue CrimsonWizardSamuraiArmorDurability;
    public static ForgeConfigSpec.IntValue CrimsonWizardSamuraiArmorEnchantmentValue;
    public static ForgeConfigSpec.DoubleValue CrimsonWizardSamuraiArmorToughness;
    public static ForgeConfigSpec.DoubleValue CrimsonWizardSamuraiArmorKnockbackResistance;
    public static ForgeConfigSpec.IntValue CrimsonWizardSamuraiArmorMana;
    public static ForgeConfigSpec.DoubleValue CrimsonWizardSamuraiArmorBloodSpellPower;
    public static ForgeConfigSpec.DoubleValue CrimsonWizardSamuraiArmorBloodMagicResistance;
    public static ForgeConfigSpec.DoubleValue CrimsonWizardSamuraiArmorSpellResistance;

    private static ArmorValues setupArmorConfig(ForgeConfigSpec.Builder builder, String armorKey, List<Integer> armorPoints, String description) {
        return new ArmorValues((ForgeConfigSpec.ConfigValue<List<? extends Integer>>)builder.comment(description).defineList(armorKey, () -> armorPoints, p -> p instanceof Integer));
    }

    public static void loadConfig(ForgeConfigSpec config, String path) {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        WizardSamuraiArmorDurability = builder.comment("Wizard Samurai Armor Durability").defineInRange("armor.wizard_samurai.durability", 375, 0, Integer.MAX_VALUE);
        WizardSamuraiArmorEnchantmentValue = builder.comment("Wizard Samurai Armor Enchantment Value").defineInRange("armor.wizard_samurai.enchantment", 15, 1, 30);
        WizardSamuraiArmorToughness = builder.comment("Wizard Samurai Armor Toughness").defineInRange("armor.wizard_samurai.toughness", 6.0, 0.0, 30.0);
        WizardSamuraiArmorKnockbackResistance = builder.comment("Wizard Samurai Armor Knockback Resistance").defineInRange("armor.wizard_samurai.knockback_resistance", 0.4, 0.0, 10.0);
        WizardSamuraiArmorMana = builder.comment("Wizard Samurai Armor Mana").defineInRange("armor.wizard_samurai.mana", 100, 0, 1000);
        WizardSamuraiArmorManaRegen = builder.comment("Wizard Samurai Armor Mana Regen").defineInRange("armor.wizard_samurai.mana_regen", 0.05, 0.0, 100.0);
        WizardSamuraiArmorCastSpeed = builder.comment("Wizard Samurai Armor Cast Speed").defineInRange("armor.wizard_samurai.cast_speed", 0.05, 0.0, 100.0);
        WizardSamuraiArmorSpellResistance = builder.comment("Wizard Samurai Armor Spell Resistance").defineInRange("armor.wizard_samurai.spell_resistance", 0.05, 0.0, 100.0);
        WizardSamuraiArmorSpellPower = builder.comment("Wizard Samurai Armor Spell Power").defineInRange("armor.wizard_samurai.spell_power", 0.05, 0.0, 100.0);
        WizardSamuraiArmorSpellCooldown = builder.comment("Wizard Samurai Armor Spell Cooldown").defineInRange("armor.wizard_samurai.spell_cooldown", 0.02, 0.0, 100.0);
        IgnisSamuraiArmorDurability = builder.comment("Ignis Samurai Armor Durability").defineInRange("armor.ignis_samurai.durability", 374, 0, Integer.MAX_VALUE);
        IgnisSamuraiArmorEnchantmentValue = builder.comment("Ignis Samurai Armor Enchantment Value").defineInRange("armor.ignis_samurai.enchantment", 15, 1, 30);
        IgnisSamuraiArmorToughness = builder.comment("Ignis Samurai Armor Toughness").defineInRange("armor.ignis_samurai.toughness", 3.0, 0.0, 30.0);
        IgnisSamuraiArmorKnockbackResistance = builder.comment("Ignis Samurai Armor Knockback Resistance").defineInRange("armor.ignis_samurai.knockback_resistance", 0.3, 0.0, 10.0);
        IgnisWizardSamuraiArmorDurability = builder.comment("Ignis Wizard Samurai Armor Durability").defineInRange("armor.ignis_wizard_samurai.durability", 374, 0, Integer.MAX_VALUE);
        IgnisWizardSamuraiArmorEnchantmentValue = builder.comment("Ignis Wizard Samurai Armor Enchantment Value").defineInRange("armor.ignis_wizard_samurai.enchantment", 15, 1, 30);
        IgnisWizardSamuraiArmorToughness = builder.comment("Ignis Wizard Samurai Armor Toughness").defineInRange("armor.ignis_wizard_samurai.toughness", 4.0, 0.0, 30.0);
        IgnisWizardSamuraiArmorKnockbackResistance = builder.comment("Ignis Wizard Samurai Armor Knockback Resistance").defineInRange("armor.ignis_wizard_samurai.knockback_resistance", 0.3, 0.0, 10.0);
        IgnisWizardSamuraiArmorSpellResistance = builder.comment("Ignis Wizard Samurai Armor Spell Resistance").defineInRange("armor.ignis_wizard_samurai.spell_resistance", 0.05, 0.0, 100.0);
        IgnisWizardSamuraiArmorSpellPower = builder.comment("Ignis Wizard Samurai Armor Spell Power").defineInRange("armor.ignis_wizard_samurai.spell_power", 0.05, 0.0, 100.0);
        IgnisWizardSamuraiArmorMana = builder.comment("Ignis Wizard Samurai Armor Mana").defineInRange("armor.ignis_wizard_samurai.mana", 75, 0, 1000);
        SculkWizardSamuraiArmorDurability = builder.comment("Sculk Wizard Samurai Armor Durability").defineInRange("armor.sculk_wizard_samurai.durability", 374, 0, Integer.MAX_VALUE);
        SculkWizardSamuraiArmorEnchantmentValue = builder.comment("Sculk Wizard Samurai Armor Enchantment Value").defineInRange("armor.sculk_wizard_samurai.enchantment", 15, 1, 30);
        SculkWizardSamuraiArmorToughness = builder.comment("Sculk Wizard Samurai Armor Toughness").defineInRange("armor.sculk_wizard_samurai.toughness", 6.0, 0.0, 30.0);
        SculkWizardSamuraiArmorKnockbackResistance = builder.comment("Sculk Wizard Samurai Armor Knockback Resistance").defineInRange("armor.sculk_wizard_samurai.knockback_resistance", 0.4, 0.0, 10.0);
        SculkWizardSamuraiArmorSpellResistance = builder.comment("Sculk Wizard Samurai Armor Spell Resistance").defineInRange("armor.sculk_wizard_samurai.spell_resistance", 0.05, 0.0, 100.0);
        SculkWizardSamuraiArmorMana = builder.comment("Sculk Wizard Samurai Armor Mana").defineInRange("armor.sculk_wizard_samurai.mana", 150, 0, 1000);
        SculkWizardSamuraiArmorSpellEldritch = builder.comment("Sculk Wizard Samurai Armor Spell Eldritch").defineInRange("armor.sculk_wizard_samurai.spell_eldritch", 0.1, 0.0, 10.0);
        AmethystWizardSamuraiArmorDurability = builder.comment("Amethyst Wizard Samurai Armor Durability").defineInRange("armor.amethyst_wizard_samurai.durability", 374, 0, Integer.MAX_VALUE);
        AmethystWizardSamuraiArmorEnchantmentValue = builder.comment("Amethyst Wizard Samurai Armor Enchantment Value").defineInRange("armor.amethyst_wizard_samurai.enchantment", 15, 1, 30);
        AmethystWizardSamuraiArmorToughness = builder.comment("Amethyst Wizard Samurai Armor Toughness").defineInRange("armor.amethyst_wizard_samurai.toughness", 6.0, 0.0, 30.0);
        AmethystWizardSamuraiArmorKnockbackResistance = builder.comment("Amethyst Wizard Samurai Armor Knockback Resistance").defineInRange("armor.amethyst_wizard_samurai.knockback_resistance", 0.3, 0.0, 10.0);
        AmethystWizardSamuraiArmorSpellResistance = builder.comment("Amethyst Wizard Samurai Armor Spell Resistance").defineInRange("armor.amethyst_wizard_samurai.spell_resistance", 0.05, 0.0, 100.0);
        AmethystWizardSamuraiArmorMana = builder.comment("Amethyst Wizard Samurai Armor Mana").defineInRange("armor.amethyst_wizard_samurai.mana", 150, 0, 1000);
        AmethystWizardSamuraiArmorManaRegen = builder.comment("Amethyst Wizard Samurai Armor Mana Regen").defineInRange("armor.amethyst_wizard_samurai.mana_regen", 0.1, 0.0, 10.0);
        AmethystWizardSamuraiArmorSpellCooldown = builder.comment("Amethyst Wizard Samurai Armor Spell Cooldown").defineInRange("armor.amethyst_wizard_samurai.spell_cooldown", 0.1, 0.0, 10.0);
        AmethystWizardSamuraiArmorCastSpeed = builder.comment("Amethyst Wizard Samurai Armor Cast Speed").defineInRange("armor.amethyst_wizard_samurai.cast_speed", 0.1, 0.0, 10.0);
        CrimsonWizardSamuraiArmorDurability = builder.comment("Crimson Wizard Samurai Armor Durability").defineInRange("armor.crimson_wizard_samurai.durability", 374, 0, Integer.MAX_VALUE);
        CrimsonWizardSamuraiArmorEnchantmentValue = builder.comment("Crimson Wizard Samurai Armor Enchantment Value").defineInRange("armor.crimson_wizard_samurai.enchantment", 15, 1, 30);
        CrimsonWizardSamuraiArmorToughness = builder.comment("Crimson Wizard Samurai Armor Toughness").defineInRange("armor.crimson_wizard_samurai.toughness", 6.0, 0.0, 30.0);
        CrimsonWizardSamuraiArmorKnockbackResistance = builder.comment("Crimson Wizard Samurai Armor Knockback Resistance").defineInRange("armor.crimson_wizard_samurai.knockback_resistance", 0.3, 0.0, 10.0);
        CrimsonWizardSamuraiArmorMana = builder.comment("Crimson Wizard Samurai Armor Mana").defineInRange("armor.crimson_wizard_samurai.mana", 150, 0, 1000);
        CrimsonWizardSamuraiArmorBloodSpellPower = builder.comment("Crimson Wizard Samurai Armor Blood Spell Power").defineInRange("armor.crimson_wizard_samurai.blood_spell_power", 0.1, 0.0, 100.0);
        CrimsonWizardSamuraiArmorBloodMagicResistance = builder.comment("Crimson Wizard Samurai Armor Blood Magic Resistance").defineInRange("armor.crimson_wizard_samurai.blood_magic_resistance", 0.1, 0.0, 100.0);
        CrimsonWizardSamuraiArmorSpellResistance = builder.comment("Crimson Wizard Samurai Armor Spell Resistance").defineInRange("armor.crimson_wizard_samurai.spell_resistance", 0.05, 0.0, 100.0);
        WizardSamuraiArmorValue = ArmorConfig.setupArmorConfig(builder, "wizard_samurai_armor_values", List.of(Integer.valueOf(5), Integer.valueOf(8), Integer.valueOf(11), Integer.valueOf(6)), "Defines armor values and additional values for Wizard Samurai armor.");
        IgnisSamuraiArmorValue = ArmorConfig.setupArmorConfig(builder, "ignis_samurai_armor_values", List.of(Integer.valueOf(6), Integer.valueOf(9), Integer.valueOf(12), Integer.valueOf(7)), "Defines armor values for Ignis Samurai armor.");
        IgnisWizardSamuraiArmorValue = ArmorConfig.setupArmorConfig(builder, "ignis_wizard_samurai_armor_values", List.of(Integer.valueOf(6), Integer.valueOf(9), Integer.valueOf(12), Integer.valueOf(7)), "Defines armor values for Ignis Wizard Samurai armor.");
        SculkWizardSamuraiArmorValue = ArmorConfig.setupArmorConfig(builder, "sculk_wizard_samurai_armor_values", List.of(Integer.valueOf(3), Integer.valueOf(6), Integer.valueOf(8), Integer.valueOf(3)), "Defines armor values for Sculk Wizard Samurai armor.");
        AmethystWizardSamuraiArmorValue = ArmorConfig.setupArmorConfig(builder, "amethyst_wizard_samurai_armor_values", List.of(Integer.valueOf(2), Integer.valueOf(5), Integer.valueOf(7), Integer.valueOf(2)), "Defines armor values for Amethyst Wizard Samurai armor.");
        CrimsonWizardSamuraiArmorValue = ArmorConfig.setupArmorConfig(builder, "crimson_wizard_samurai_armor_values", List.of(Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(8), Integer.valueOf(4)), "Defines armor values for Crimson Wizard Samurai armor.");
        ARMOR_SPEC = builder.build();
    }

    public record ArmorValues(ForgeConfigSpec.ConfigValue<List<? extends Integer>> armor) {
        public int getProtectionValues(EquipmentSlot slot) {
            if (((List)this.armor.get()).size() != 5) {
                return (Integer)((List)this.armor.getDefault()).get(slot.m_20749_());
            }
            return (Integer)((List)this.armor.get()).get(slot.m_20749_());
        }
    }
}

