/*
 * Decompiled with CFR 0.152.
 */
package ua.archijk.wizard_samurai;

import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.render.SpellBookCurioRenderer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import ua.archijk.wizard_samurai.config.AccessoryConfig;
import ua.archijk.wizard_samurai.config.ArmorConfig;
import ua.archijk.wizard_samurai.config.WeaponConfig;
import ua.archijk.wizard_samurai.crafting.init.data.ModDataGen;
import ua.archijk.wizard_samurai.crafting.init.registry.ModBlocks;
import ua.archijk.wizard_samurai.crafting.init.registry.ModItems;
import ua.archijk.wizard_samurai.crafting.init.registry.ModMenus;
import ua.archijk.wizard_samurai.crafting.init.registry.ModRecipeSerializers;
import ua.archijk.wizard_samurai.crafting.init.registry.ModRecipeTypes;
import ua.archijk.wizard_samurai.crafting.init.registry.ModTileEntities;
import ua.archijk.wizard_samurai.items.mask.curios.model.mask.WizardSamuraiMaskCuriosModel;
import ua.archijk.wizard_samurai.items.mask.curios.render.mask.AmethystWizardSamuraiMaskCuriosRenderer;
import ua.archijk.wizard_samurai.items.mask.curios.render.mask.CrimsonWizardSamuraiMaskCuriosRenderer;
import ua.archijk.wizard_samurai.items.mask.curios.render.mask.SculkWizardSamuraiMaskCuriosRenderer;
import ua.archijk.wizard_samurai.items.mask.curios.render.mask.WizardSamuraiMaskCuriosRenderer;
import ua.archijk.wizard_samurai.registries.CreativeTabRegistry;
import ua.archijk.wizard_samurai.registries.ItemRegistries;

@Mod(value="wizard_samurai")
public class WizardSamurai {
    public static final String MOD_ID = "wizard_samurai";
    public static final Logger LOGGER = LogManager.getLogger();

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static Item getItem(String modid, String name) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modid, name));
    }

    public static boolean isLoad(String name) {
        return ModList.get().isLoaded(name);
    }

    public WizardSamurai() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ItemRegistries.register(modEventBus);
        CreativeTabRegistry.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(ModDataGen::gatherData);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModTileEntities.BLOCK_ENTITIES.register(modEventBus);
        ModMenus.MENUS.register(modEventBus);
        ModRecipeTypes.RECIPES.register(modEventBus);
        ModRecipeSerializers.SERIALIZERS.register(modEventBus);
        Path configWizardSamuraiPath = FMLPaths.CONFIGDIR.get().resolve(MOD_ID);
        try {
            Files.createDirectories(configWizardSamuraiPath, new FileAttribute[0]);
        }
        catch (Exception e) {
            LOGGER.error("Failed WZ Config Load: " + String.valueOf(configWizardSamuraiPath), (Throwable)e);
        }
        ArmorConfig.loadConfig(ArmorConfig.ARMOR_SPEC, configWizardSamuraiPath.resolve("wizard_samurai_armor.toml").toString());
        WeaponConfig.loadConfig(WeaponConfig.WEAPON_SPEC, configWizardSamuraiPath.resolve("wizard_samurai_weapon.toml").toString());
        AccessoryConfig.loadConfig(AccessoryConfig.ACCESSORY_SPEC, configWizardSamuraiPath.resolve("wizard_samurai_accessory.toml").toString());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @Mod.EventBusSubscriber(modid="wizard_samurai", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerLayerRenderers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(WizardSamuraiMaskCuriosModel.LAYER_LOCATION, WizardSamuraiMaskCuriosModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            CuriosRendererRegistry.register((Item)((Item)ItemRegistries.WIZARD_SAMURAI_MASK.get()), WizardSamuraiMaskCuriosRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ItemRegistries.SCULK_WIZARD_SAMURAI_MASK.get()), SculkWizardSamuraiMaskCuriosRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ItemRegistries.AMETHYST_WIZARD_SAMURAI_MASK.get()), AmethystWizardSamuraiMaskCuriosRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ItemRegistries.CRIMSON_WIZARD_SAMURAI_MASK.get()), CrimsonWizardSamuraiMaskCuriosRenderer::new);
            event.enqueueWork(() -> ItemRegistries.getWSItems().stream().filter(item -> item.get() instanceof SpellBook).forEach(item -> CuriosRendererRegistry.register((Item)((Item)item.get()), SpellBookCurioRenderer::new)));
        }
    }
}

