/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class WisteriaTrunkPlacer
extends TrunkPlacer {
    public static final Codec<WisteriaTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> WisteriaTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.f_146533_.fieldOf("extra_branch_steps").forGetter(WisteriaTrunkPlacer2 -> WisteriaTrunkPlacer2.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(WisteriaTrunkPlacer2 -> Float.valueOf(WisteriaTrunkPlacer2.placeBranchPerLogProbability)), (App)IntProvider.f_146532_.fieldOf("extra_branch_length").forGetter(WisteriaTrunkPlacer2 -> WisteriaTrunkPlacer2.extraBranchLength), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256747_).fieldOf("can_grow_through").forGetter(WisteriaTrunkPlacer2 -> WisteriaTrunkPlacer2.canGrowThrough))).apply((Applicative)instance, WisteriaTrunkPlacer::new));
    private final IntProvider extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final IntProvider extraBranchLength;
    private final HolderSet<Block> canGrowThrough;

    public WisteriaTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength, HolderSet<Block> canGrowThrough) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
        this.canGrowThrough = canGrowThrough;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)NSWorldGen.WISTERIA_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < height; ++i) {
            int j = startPos.m_123342_() + i;
            if (this.m_226187_(world, replacer, random, (BlockPos)mutable.m_122178_(startPos.m_123341_(), j, startPos.m_123343_()), config) && i < height - 3 && i > 2 && random.m_188501_() < this.placeBranchPerLogProbability) {
                Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
                int k = this.extraBranchLength.m_214085_(random);
                int l = Math.max(0, k - this.extraBranchLength.m_214085_(random) - 1);
                int m = this.extraBranchSteps.m_214085_(random);
                int g = startPos.m_123342_() + i - 1;
                this.placeBranch(world, replacer, random, height, config, list, mutable, j, direction, l, m);
            }
            if (i + 1 != height) continue;
            list.add(new FoliagePlacer.FoliageAttachment((BlockPos)mutable.m_122178_(startPos.m_123341_(), j, startPos.m_123343_()), -1, false));
        }
        return list;
    }

    private void placeBranch(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> nodes, BlockPos.MutableBlockPos pos, int yOffset, Direction direction, int length, int steps) {
        int i = yOffset + length;
        int j = pos.m_123341_();
        int k = pos.m_123343_();
        for (int l = length; l < height && steps > 0; ++l, --steps) {
            if (l < 1) continue;
            int m = yOffset + l;
            i = m;
            if (!this.m_226187_(world, replacer, random, (BlockPos)pos.m_122178_(j += direction.m_122429_(), m, k += direction.m_122431_()), config)) continue;
            i = m + 1;
        }
        if (i - yOffset > 1) {
            BlockPos blockPos = new BlockPos(j, i, k);
            nodes.add(new FoliagePlacer.FoliageAttachment(blockPos, 0, false));
        }
    }

    protected boolean m_213554_(LevelSimulatedReader levelSimulatedReader, BlockPos blockPos) {
        return super.m_213554_(levelSimulatedReader, blockPos) || levelSimulatedReader.m_7433_(blockPos, blockState -> blockState.m_204341_(this.canGrowThrough));
    }
}

