/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class SugiTrunkPlacer
extends TrunkPlacer {
    public static final Codec<SugiTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> SugiTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.f_146533_.fieldOf("extra_branch_steps").forGetter(trunkPlacer -> trunkPlacer.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.placeBranchPerLogProbability)), (App)IntProvider.f_146532_.fieldOf("extra_branch_length").forGetter(trunkPlacer -> trunkPlacer.extraBranchLength), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256747_).fieldOf("can_grow_through").forGetter(trunkPlacer -> trunkPlacer.canGrowThrough))).apply((Applicative)instance, SugiTrunkPlacer::new));
    private final IntProvider extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final IntProvider extraBranchLength;
    private final HolderSet<Block> canGrowThrough;

    public SugiTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength, HolderSet<Block> canGrowThrough) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
        this.canGrowThrough = canGrowThrough;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)NSWorldGen.SUGI_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
        for (int i = 0; i < height; ++i) {
            int j = startPos.m_123342_() + i;
            if (this.m_226187_(world, replacer, random, (BlockPos)mutable.m_122178_(startPos.m_123341_(), j, startPos.m_123343_()), config) && i < height - 1 && i > 3) {
                direction = direction.m_122427_();
                Direction direction2 = direction.m_122427_();
                Direction direction3 = direction2.m_122427_();
                int m = height - i - 2;
                this.generateExtraBranch(world, replacer, random, height, config, list, mutable, j, direction, Math.min(m, 5), i);
                if ((double)random.m_188501_() < (double)this.placeBranchPerLogProbability - 0.25) {
                    this.generateExtraBranch(world, replacer, random, height, config, list, mutable, j, direction2, Math.min(m, 5), i);
                }
                if ((double)random.m_188501_() < (double)this.placeBranchPerLogProbability - 0.35) {
                    this.generateExtraBranch(world, replacer, random, height, config, list, mutable, j, direction3, Math.min(m, 5), i);
                }
            }
            if (i != height - 1) continue;
            list.add(new FoliagePlacer.FoliageAttachment((BlockPos)mutable.m_122178_(startPos.m_123341_(), j + 1, startPos.m_123343_()), 0, false));
            list.add(new FoliagePlacer.FoliageAttachment((BlockPos)mutable.m_122178_(startPos.m_123341_(), j, startPos.m_123343_()), 0, false));
        }
        return list;
    }

    private void generateExtraBranch(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> nodes, BlockPos.MutableBlockPos pos, int yOffset, Direction direction, int steps, int b) {
        int j = pos.m_123341_();
        int k = pos.m_123343_();
        boolean bl = random.m_188501_() < 0.5f;
        Direction direction2 = bl ? direction.m_122427_() : direction.m_122428_();
        for (int l = 0; l < height && steps > 0 && steps < (bl ? 7 : 10); ++l, --steps) {
            if (l < 1) continue;
            k = bl ? (k += Math.max(0, direction2.m_122431_() - random.m_188503_(2))) : (k += direction.m_122431_());
            this.m_226175_(world, replacer, random, (BlockPos)pos.m_122178_(j += direction.m_122429_(), yOffset, k), config, blockState -> (BlockState)blockState.m_263224_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()));
            if (l != height - 1 && steps != 1) continue;
            BlockPos blockPos = new BlockPos(j, yOffset, k);
            nodes.add(new FoliagePlacer.FoliageAttachment(blockPos, b > 5 ? 0 : 1, false));
        }
    }

    protected boolean m_213554_(LevelSimulatedReader world, BlockPos pos) {
        return super.m_213554_(world, pos) || world.m_7433_(pos, state -> state.m_204341_(this.canGrowThrough));
    }
}

