/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class PaloVerdeTrunkPlacer
extends TrunkPlacer {
    public static final Codec<PaloVerdeTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> PaloVerdeTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.f_146533_.fieldOf("extra_branch_steps").forGetter(trunkPlacer -> trunkPlacer.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.placeBranchPerLogProbability)), (App)IntProvider.f_146532_.fieldOf("extra_branch_length").forGetter(trunkPlacer -> trunkPlacer.extraBranchLength), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256747_).fieldOf("can_grow_through").forGetter(trunkPlacer -> trunkPlacer.canGrowThrough))).apply((Applicative)instance, PaloVerdeTrunkPlacer::new));
    private final IntProvider extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final IntProvider extraBranchLength;
    private final HolderSet<Block> canGrowThrough;

    public PaloVerdeTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength, HolderSet<Block> canGrowThrough) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
        this.canGrowThrough = canGrowThrough;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)NSWorldGen.PALO_VERDE_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos();
        Direction trunkOffset = Direction.Plane.HORIZONTAL.m_235690_(random);
        Direction trunkOffset2 = Direction.Plane.HORIZONTAL.m_235690_(random);
        boolean bl = random.m_188499_();
        for (int i = 0; i < height; ++i) {
            BlockPos forkedBlockPos;
            int j = startPos.m_123342_() + i;
            Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
            BlockPos.MutableBlockPos mutablePos1 = mutable.m_122178_(startPos.m_123341_(), j, startPos.m_123343_());
            BlockPos pos2 = mutablePos1.m_121945_(trunkOffset);
            BlockPos pos3 = pos2.m_121945_(trunkOffset2);
            BlockPos.MutableBlockPos blockPos = i >= 2 ? (trunkOffset != trunkOffset2 ? pos3 : pos2) : mutablePos1;
            int l = Math.toIntExact(Math.round(Math.pow(random.m_188583_(), 0.15f) * 3.5)) - 1;
            float float1 = random.m_188501_();
            float float2 = random.m_188501_();
            if (i == 2) {
                this.m_226187_(world, replacer, random, (BlockPos)mutablePos1, config);
            }
            if (this.m_226187_(world, replacer, random, (BlockPos)blockPos, config) && i < height - 1) {
                int m = height + i - 5;
                if (i > 1 && l > 0) {
                    this.generateExtraBranch(world, replacer, random, config, list, (BlockPos)blockPos, height, j, direction, l, m);
                    if ((double)float1 < (double)this.placeBranchPerLogProbability - 0.35) {
                        this.generateExtraBranch(world, replacer, random, config, list, (BlockPos)blockPos, height, j, direction.m_122427_(), l, m);
                    }
                    if ((double)float1 < (double)this.placeBranchPerLogProbability - 0.65) {
                        this.generateExtraBranch(world, replacer, random, config, list, (BlockPos)blockPos, height, j, direction.m_122427_().m_122427_(), l, m);
                    }
                }
            }
            if (i == height - 1) {
                list.add(new FoliagePlacer.FoliageAttachment(blockPos.m_6630_(1), 0, false));
            }
            if (!bl || i < 2) continue;
            Direction forkedDirection = Direction.Plane.HORIZONTAL.m_235690_(random);
            BlockPos.MutableBlockPos forkedMutablePos1 = mutable2.m_122178_(startPos.m_123341_(), j, startPos.m_123343_());
            BlockPos forkedPos2 = forkedMutablePos1.m_121945_(trunkOffset.m_122424_()).m_121945_(Direction.DOWN);
            BlockPos forkedPos3 = forkedPos2.m_121945_(trunkOffset2.m_122424_());
            BlockPos blockPos2 = forkedBlockPos = trunkOffset.m_122424_() != trunkOffset2.m_122424_() ? forkedPos3 : forkedPos2;
            if (i == 2) {
                this.m_226187_(world, replacer, random, (BlockPos)forkedMutablePos1, config);
            }
            if (this.m_226187_(world, replacer, random, forkedBlockPos, config) && i < height - 1) {
                int m = height + i - 5;
                if (i > 1 && l > 0) {
                    this.generateExtraBranch(world, replacer, random, config, list, forkedBlockPos, height, j, forkedDirection, l, m);
                    if ((double)float2 < (double)this.placeBranchPerLogProbability - 0.35) {
                        this.generateExtraBranch(world, replacer, random, config, list, forkedBlockPos, height, j, forkedDirection.m_122427_(), l, m);
                    }
                    if ((double)float2 < (double)this.placeBranchPerLogProbability - 0.65) {
                        this.generateExtraBranch(world, replacer, random, config, list, forkedBlockPos, height, j, forkedDirection.m_122427_().m_122427_(), l, m);
                    }
                }
            }
            if (i != height - 2) continue;
            list.add(new FoliagePlacer.FoliageAttachment(forkedBlockPos.m_6630_(1), 0, false));
        }
        return list;
    }

    private void generateExtraBranch(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> nodes, BlockPos pos, int height, int yOffset, Direction direction, int length, int steps) {
        int i = yOffset + length;
        int j = pos.m_123341_();
        int k = pos.m_123343_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        boolean bl = random.m_188501_() < 0.5f;
        Direction direction2 = random.m_188501_() < 0.5f ? direction.m_122427_() : direction.m_122428_();
        for (int l = length; l < height - 3 && steps > 0; ++l, --steps) {
            if (l < 1) continue;
            int m = Math.round(yOffset + l / 5);
            j += direction.m_122429_();
            k = bl ? (k += Math.max(0, direction2.m_122431_() - random.m_188503_(2))) : (k += direction.m_122431_());
            if (!this.m_226175_(world, replacer, random, (BlockPos)mutable.m_122178_(j, m, k), config, blockState -> (BlockState)blockState.m_263224_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()))) continue;
            i = m + 1;
        }
        if (i - yOffset >= 1) {
            BlockPos blockPos = new BlockPos(j, i, k);
            nodes.add(new FoliagePlacer.FoliageAttachment(blockPos, 0, false));
        }
    }

    protected boolean m_213554_(LevelSimulatedReader world, BlockPos pos) {
        return super.m_213554_(world, pos) || world.m_7433_(pos, state -> state.m_204341_(this.canGrowThrough));
    }
}

