/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class OliveTrunkPlacer
extends TrunkPlacer {
    public static final Codec<OliveTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> OliveTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.f_146533_.fieldOf("extra_branch_steps").forGetter(trunkPlacer -> trunkPlacer.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.placeBranchPerLogProbability)), (App)IntProvider.f_146532_.fieldOf("extra_branch_length").forGetter(trunkPlacer -> trunkPlacer.extraBranchLength), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256747_).fieldOf("can_grow_through").forGetter(trunkPlacer -> trunkPlacer.canGrowThrough))).apply((Applicative)instance, OliveTrunkPlacer::new));
    private final IntProvider extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final IntProvider extraBranchLength;
    private final HolderSet<Block> canGrowThrough;

    public OliveTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength, HolderSet<Block> canGrowThrough) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
        this.canGrowThrough = canGrowThrough;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)NSWorldGen.OLIVE_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        BlockPos blockPos = startPos.m_7495_();
        OliveTrunkPlacer.m_226169_((LevelSimulatedReader)world, replacer, (RandomSource)random, (BlockPos)blockPos, (TreeConfiguration)config);
        OliveTrunkPlacer.m_226169_((LevelSimulatedReader)world, replacer, (RandomSource)random, (BlockPos)blockPos.m_122029_(), (TreeConfiguration)config);
        OliveTrunkPlacer.m_226169_((LevelSimulatedReader)world, replacer, (RandomSource)random, (BlockPos)blockPos.m_122019_(), (TreeConfiguration)config);
        OliveTrunkPlacer.m_226169_((LevelSimulatedReader)world, replacer, (RandomSource)random, (BlockPos)blockPos.m_122019_().m_122029_(), (TreeConfiguration)config);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < height; ++i) {
            int j = startPos.m_123342_() + i;
            BlockPos.MutableBlockPos mutablePos1 = mutable.m_122178_(startPos.m_123341_(), j, startPos.m_123343_());
            this.m_226187_(world, replacer, random, (BlockPos)mutablePos1, config);
            this.m_226187_(world, replacer, random, mutablePos1.m_122029_(), config);
            this.m_226187_(world, replacer, random, mutablePos1.m_122019_(), config);
            this.m_226187_(world, replacer, random, mutablePos1.m_122019_().m_122029_(), config);
            if (i == 0) {
                this.m_226187_(world, replacer, random, this.getRoot(random, mutablePos1), config);
                this.m_226187_(world, replacer, random, this.getRoot(random, mutablePos1), config);
            }
            if (i != height - 1) continue;
            this.generateExtraBranch(world, replacer, random, config, list, mutablePos1.m_122013_(1), j, Direction.NORTH, this.extraBranchSteps.m_214085_(random));
            if ((double)random.m_188501_() < (double)this.placeBranchPerLogProbability - 0.65) {
                this.generateExtraBranch(world, replacer, random, config, list, mutablePos1.m_122025_(1), j, Direction.WEST, this.extraBranchSteps.m_214085_(random));
            }
            this.generateExtraBranch(world, replacer, random, config, list, mutablePos1.m_122020_(2), j, Direction.SOUTH, this.extraBranchSteps.m_214085_(random));
            if ((double)random.m_188501_() < (double)this.placeBranchPerLogProbability - 0.65) {
                this.generateExtraBranch(world, replacer, random, config, list, mutablePos1.m_122020_(2), j, Direction.WEST, this.extraBranchSteps.m_214085_(random));
            }
            this.generateExtraBranch(world, replacer, random, config, list, mutablePos1.m_122030_(2), j, Direction.EAST, this.extraBranchSteps.m_214085_(random));
            if ((double)random.m_188501_() < (double)this.placeBranchPerLogProbability - 0.65) {
                this.generateExtraBranch(world, replacer, random, config, list, mutablePos1.m_122030_(2), j, Direction.NORTH, this.extraBranchSteps.m_214085_(random));
            }
            this.generateExtraBranch(world, replacer, random, config, list, mutablePos1.m_122020_(2).m_122029_(), j, Direction.WEST, this.extraBranchSteps.m_214085_(random));
            if (!((double)random.m_188501_() < (double)this.placeBranchPerLogProbability - 0.65)) continue;
            this.generateExtraBranch(world, replacer, random, config, list, mutablePos1.m_122019_().m_122030_(2), j, Direction.SOUTH, this.extraBranchSteps.m_214085_(random));
        }
        return list;
    }

    private void generateExtraBranch(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> nodes, BlockPos pos, int yOffset, Direction direction, int steps) {
        int m = yOffset;
        int j = pos.m_123341_();
        int k = pos.m_123343_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        boolean bl = random.m_188499_();
        Direction direction2 = random.m_188499_() ? direction.m_122427_() : direction.m_122428_();
        int l = 0;
        while (steps > 0) {
            boolean bl2 = random.m_188499_();
            m = yOffset + l;
            if (bl2 && l != 0) {
                j += direction.m_122429_();
                k = bl ? (k += Math.max(0, direction2.m_122431_() - random.m_188503_(2))) : (k += direction.m_122431_());
            }
            int finalL = l++;
            this.m_226175_(world, replacer, random, (BlockPos)mutable.m_122178_(j, m, k), config, blockState -> (BlockState)blockState.m_263224_((Property)RotatedPillarBlock.f_55923_, (Comparable)(bl2 || finalL == 0 ? direction.m_122434_() : Direction.Axis.Y)));
            --steps;
        }
        if (m - yOffset >= 1) {
            nodes.add(new FoliagePlacer.FoliageAttachment(new BlockPos(j, m, k), 0, false));
        }
    }

    protected boolean m_213554_(LevelSimulatedReader world, BlockPos pos) {
        return super.m_213554_(world, pos) || world.m_7433_(pos, state -> state.m_204341_(this.canGrowThrough));
    }

    protected BlockPos getRoot(RandomSource random, BlockPos.MutableBlockPos mutablePos1) {
        return switch (random.m_188503_(7)) {
            case 1 -> mutablePos1.m_122030_(2);
            case 2 -> mutablePos1.m_122020_(2);
            case 3 -> mutablePos1.m_122020_(2).m_122029_();
            case 4 -> mutablePos1.m_122024_();
            case 5 -> mutablePos1.m_122029_().m_122012_();
            case 6 -> mutablePos1.m_122019_().m_122030_(2);
            case 7 -> mutablePos1.m_122019_().m_122024_();
            default -> mutablePos1.m_122012_();
        };
    }
}

