/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.trunk;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class MapleTrunkPlacer
extends TrunkPlacer {
    private static final Codec<UniformInt> BRANCH_START_OFFSET_FROM_TOP_CODEC = ExtraCodecs.m_264370_((Codec)UniformInt.f_146614_, branchStartOffsetFromTop -> branchStartOffsetFromTop.m_142737_() - branchStartOffsetFromTop.m_142739_() < 1 ? DataResult.error(() -> "Need at least 2 blocks variation for the branch starts to fit both branches") : DataResult.success((Object)branchStartOffsetFromTop));
    public static final Codec<MapleTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> MapleTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.m_146545_((int)1, (int)5).fieldOf("branch_count").forGetter(trunkPlacer -> trunkPlacer.branchCount), (App)IntProvider.m_146545_((int)1, (int)16).fieldOf("branch_horizontal_length").forGetter(trunkPlacer -> trunkPlacer.branchHorizontalLength), (App)IntProvider.m_272161_((int)-16, (int)0, BRANCH_START_OFFSET_FROM_TOP_CODEC).fieldOf("branch_start_offset_from_top").forGetter(trunkPlacer -> trunkPlacer.branchStartOffsetFromTop), (App)IntProvider.m_146545_((int)-16, (int)16).fieldOf("branch_end_offset_from_top").forGetter(trunkPlacer -> trunkPlacer.branchEndOffsetFromTop))).apply((Applicative)instance, MapleTrunkPlacer::new));
    private final IntProvider branchCount;
    private final IntProvider branchHorizontalLength;
    private final UniformInt branchStartOffsetFromTop;
    private final UniformInt secondBranchStartOffsetFromTop;
    private final IntProvider branchEndOffsetFromTop;

    public MapleTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, IntProvider branchCount, IntProvider branchHorizontalLength, UniformInt branchStartOffsetFromTop, IntProvider branchEndOffsetFromTop) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.branchCount = branchCount;
        this.branchHorizontalLength = branchHorizontalLength;
        this.branchStartOffsetFromTop = branchStartOffsetFromTop;
        this.secondBranchStartOffsetFromTop = UniformInt.m_146622_((int)branchStartOffsetFromTop.m_142739_(), (int)(branchStartOffsetFromTop.m_142737_() - 1));
        this.branchEndOffsetFromTop = branchEndOffsetFromTop;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)NSWorldGen.MAPLE_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        boolean bl4;
        int k;
        MapleTrunkPlacer.m_226169_((LevelSimulatedReader)world, replacer, (RandomSource)random, (BlockPos)startPos.m_7495_(), (TreeConfiguration)config);
        int i = Math.max(0, height - 1 + this.branchStartOffsetFromTop.m_214085_(random));
        int j = Math.max(0, height - 1 + this.secondBranchStartOffsetFromTop.m_214085_(random));
        if (j >= i) {
            ++j;
        }
        boolean bl = (k = this.branchCount.m_214085_(random)) >= 3;
        boolean bl2 = k >= 2;
        boolean bl3 = k >= 4;
        boolean bl5 = bl4 = k == 5;
        int l = bl ? height : (bl2 ? Math.max(i, j) + 1 : i + 1);
        for (int m = 0; m < l; ++m) {
            this.m_226187_(world, replacer, random, startPos.m_6630_(m), config);
        }
        ArrayList<FoliagePlacer.FoliageAttachment> list = new ArrayList<FoliagePlacer.FoliageAttachment>();
        if (bl) {
            list.add(new FoliagePlacer.FoliageAttachment(startPos.m_6630_(l), 0, false));
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
        Direction direction2 = direction.m_175362_(Direction.Axis.Y);
        Function<BlockState, BlockState> function = state -> (BlockState)state.m_263224_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_());
        Function<BlockState, BlockState> function2 = state -> (BlockState)state.m_263224_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction2.m_122434_());
        list.add(this.generateBranch(world, replacer, random, height, startPos, config, function, direction, i, i < l - 1, mutable));
        if (bl2) {
            list.add(this.generateBranch(world, replacer, random, height, startPos, config, function, direction.m_122424_(), j, j < l - 1, mutable));
        }
        if (bl3) {
            list.add(this.generateBranch(world, replacer, random, height, startPos, config, function2, direction2, j, j < l - 1, mutable));
        }
        if (bl4) {
            list.add(this.generateBranch(world, replacer, random, height, startPos, config, function2, direction2.m_122424_(), j, j < l - 1, mutable));
        }
        return list;
    }

    private FoliagePlacer.FoliageAttachment generateBranch(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config, Function<BlockState, BlockState> withAxisFunction, Direction direction, int branchStartOffset, boolean branchBelowHeight, BlockPos.MutableBlockPos mutablePos) {
        Direction direction2;
        mutablePos.m_122190_((Vec3i)startPos).m_122175_(Direction.UP, branchStartOffset);
        int i = height - 1 + this.branchEndOffsetFromTop.m_214085_(random);
        boolean bl = branchBelowHeight || i < branchStartOffset;
        int j = this.branchHorizontalLength.m_214085_(random) + (bl ? 1 : 0);
        BlockPos blockPos = startPos.m_5484_(direction, j).m_6630_(i);
        int k = bl ? 2 : 1;
        for (int l = 0; l < k; ++l) {
            this.m_226175_(world, replacer, random, (BlockPos)mutablePos.m_122173_(direction), config, withAxisFunction);
        }
        Direction direction3 = direction2 = blockPos.m_123342_() > mutablePos.m_123342_() ? Direction.UP : Direction.DOWN;
        int m;
        while ((m = mutablePos.m_123333_((Vec3i)blockPos)) != 0) {
            float f = (float)Math.abs(blockPos.m_123342_() - mutablePos.m_123342_()) / (float)m;
            boolean bl2 = random.m_188501_() < f;
            mutablePos.m_122173_(bl2 ? direction2 : direction);
            this.m_226175_(world, replacer, random, (BlockPos)mutablePos, config, bl2 ? Function.identity() : withAxisFunction);
        }
        return new FoliagePlacer.FoliageAttachment(blockPos.m_7494_(), 0, false);
    }
}

