/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class CoconutTrunkPlacer
extends TrunkPlacer {
    public static final Codec<CoconutTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> CoconutTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.f_146533_.fieldOf("trunk_steps").forGetter(trunkPlacer -> trunkPlacer.trunkSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("fork_probability").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.forkProbability)), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256747_).fieldOf("can_grow_through").forGetter(trunkPlacer -> trunkPlacer.canGrowThrough))).apply((Applicative)instance, CoconutTrunkPlacer::new));
    private final IntProvider trunkSteps;
    private final float forkProbability;
    private final HolderSet<Block> canGrowThrough;

    public CoconutTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, IntProvider trunkSteps, float forkProbability, HolderSet<Block> canGrowThrough) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.trunkSteps = trunkSteps;
        this.forkProbability = forkProbability;
        this.canGrowThrough = canGrowThrough;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)NSWorldGen.COCONUT_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122178_(startPos.m_123341_(), startPos.m_123342_() - 1, startPos.m_123343_());
        BlockPos.MutableBlockPos forkedMutable = new BlockPos.MutableBlockPos().m_122178_(startPos.m_123341_(), startPos.m_123342_() + 1, startPos.m_123343_());
        boolean forked = random.m_188501_() < this.forkProbability;
        int steps = this.trunkSteps.m_214085_(random);
        int increment = random.m_216332_(0, 1);
        int forkedIncrement = random.m_216332_(0, 1);
        Direction offsetDirection = Direction.Plane.HORIZONTAL.m_235690_(random);
        Direction offsetDirection2 = Direction.Plane.HORIZONTAL.m_235690_(random);
        int forkedOffset = random.m_216332_(0, 2);
        int forkedHeight = height - forkedOffset;
        for (int i = 0; i < height; ++i) {
            BlockPos.MutableBlockPos pos = mutable.m_122184_(0, 1, 0);
            this.m_226187_(world, replacer, random, (BlockPos)pos, config);
            if (i < 2) continue;
            if (forked && i < forkedHeight) {
                BlockPos.MutableBlockPos forkedPos = forkedMutable.m_122184_(0, 1, 0);
                this.m_226187_(world, replacer, random, (BlockPos)forkedPos, config);
                if (i == forkedHeight - 1) {
                    list.add(new FoliagePlacer.FoliageAttachment(forkedPos.m_6630_(1), 0, false));
                }
            }
            if (i == height - 1) {
                list.add(new FoliagePlacer.FoliageAttachment(pos.m_6630_(1), 0, false));
            }
            if (increment == 0) {
                mutable.m_122173_(offsetDirection);
                if (offsetDirection2 != offsetDirection) {
                    mutable.m_122173_(offsetDirection2);
                }
                increment = height / steps - random.m_216332_(-1, 1);
            }
            if (forkedIncrement == 0) {
                forkedMutable.m_122173_(offsetDirection.m_122424_());
                if (offsetDirection2 != offsetDirection && random.m_188499_()) {
                    forkedMutable.m_122173_(offsetDirection2.m_122424_());
                }
                forkedIncrement = forkedHeight / steps - random.m_216332_(-1, 1);
            }
            --increment;
            --forkedIncrement;
        }
        return list;
    }

    protected boolean m_213554_(LevelSimulatedReader world, BlockPos pos) {
        return super.m_213554_(world, pos) || world.m_7433_(pos, state -> state.m_204341_(this.canGrowThrough));
    }
}

