/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.tree_decorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.hibiscus.naturespirit.blocks.PolyporeBlock;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class PolyporeTreeDecorator
extends TreeDecorator {
    public static final Codec<PolyporeTreeDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("big_probability").forGetter(treeDecorator -> Float.valueOf(treeDecorator.big_probability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("small_probability").forGetter(treeDecorator -> Float.valueOf(treeDecorator.small_probability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(treeDecorator -> Float.valueOf(treeDecorator.chance)), (App)BlockStateProvider.f_68747_.fieldOf("block_provider").forGetter(treeDecorator -> treeDecorator.block_provider), (App)BlockStateProvider.f_68747_.fieldOf("polypore_provider").forGetter(treeDecorator -> treeDecorator.polypore_provider)).apply((Applicative)instance, PolyporeTreeDecorator::new));
    private final float big_probability;
    private final float small_probability;
    private final float chance;
    private final BlockStateProvider block_provider;
    private final BlockStateProvider polypore_provider;

    public PolyporeTreeDecorator(float big_probability, float small_probability, float chance, BlockStateProvider block_provider, BlockStateProvider polypore_provider) {
        this.chance = chance;
        this.big_probability = big_probability;
        this.small_probability = small_probability;
        this.block_provider = block_provider;
        this.polypore_provider = polypore_provider;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)NSWorldGen.POLYPORE_DECORATOR.get();
    }

    public void m_214187_(TreeDecorator.Context generator) {
        RandomSource random = generator.m_226067_();
        if (random.m_188501_() < this.chance) {
            ObjectArrayList list = generator.m_226068_();
            list.stream().filter(arg_0 -> PolyporeTreeDecorator.lambda$place$6((List)list, arg_0)).forEach(pos -> {
                Direction direction2;
                if (random.m_188501_() <= this.big_probability) {
                    for (Direction direction : Direction.Plane.HORIZONTAL.m_235694_(random)) {
                        if (!generator.m_226059_(pos.m_121945_(direction))) continue;
                        direction2 = direction.m_122427_();
                        Direction direction3 = direction.m_122428_();
                        int radius = random.m_216332_(1, 2);
                        if (generator.m_226059_(pos.m_121945_(direction2)) && generator.m_226059_(pos.m_121945_(direction2).m_121945_(direction))) {
                            this.generateSquare(generator, (BlockPos)pos, radius, direction, direction2, random);
                            break;
                        }
                        if (!generator.m_226059_(pos.m_121945_(direction3)) || !generator.m_226059_(pos.m_121945_(direction3).m_121945_(direction))) continue;
                        this.generateSquare(generator, (BlockPos)pos, radius, direction, direction3, random);
                        break;
                    }
                }
                if (random.m_188501_() <= this.small_probability) {
                    for (Direction direction : Direction.Plane.HORIZONTAL.m_235694_(random)) {
                        if (!generator.m_226059_(pos.m_121945_(direction))) continue;
                        direction2 = direction.m_122427_();
                        generator.m_226061_(pos.m_121945_(direction), (BlockState)this.polypore_provider.m_213972_(random, pos.m_121945_(direction)).m_263224_((Property)PolyporeBlock.FACING, (Comparable)direction));
                        if (!generator.m_226059_(pos.m_121945_(direction2))) break;
                        generator.m_226061_(pos.m_121945_(direction2), (BlockState)this.polypore_provider.m_213972_(random, pos.m_121945_(direction2)).m_263224_((Property)PolyporeBlock.FACING, (Comparable)direction2));
                        break;
                    }
                }
            });
        }
    }

    protected void generateSquare(TreeDecorator.Context generator, BlockPos cornerPos, int radius, Direction direction1, Direction direction2, RandomSource random) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)cornerPos);
        for (int j = 0; j <= radius; ++j) {
            for (int k = 0; k <= radius; ++k) {
                BlockPos blockPos = mutable.m_5484_(direction2, k).m_5484_(direction1, j);
                if (!generator.m_226059_(blockPos)) continue;
                generator.m_226061_(blockPos, (BlockState)this.block_provider.m_213972_(random, blockPos).m_263224_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    private static /* synthetic */ boolean lambda$place$6(List list, BlockPos pos) {
        return pos.m_123342_() < ((BlockPos)list.get(0)).m_123342_() + 6 && pos.m_123342_() > ((BlockPos)list.get(0)).m_123342_();
    }
}

