/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.tree_decorator;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.hibiscus.naturespirit.registration.NSBlocks;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class MapleGroundTreeDecorator
extends TreeDecorator {
    public static final Codec<MapleGroundTreeDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("inner_block").forGetter(treeDecorator -> treeDecorator.provider), (App)BlockStateProvider.f_68747_.fieldOf("outer_block").forGetter(treeDecorator -> treeDecorator.provider2)).apply((Applicative)instance, MapleGroundTreeDecorator::new));
    private final BlockStateProvider provider;
    private final BlockStateProvider provider2;

    public MapleGroundTreeDecorator(BlockStateProvider provider, BlockStateProvider provider2) {
        this.provider = provider;
        this.provider2 = provider2;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)NSWorldGen.MAPLE_GROUND_TREE_DECORATOR.get();
    }

    public void m_214187_(TreeDecorator.Context generator) {
        ArrayList list = Lists.newArrayList();
        ObjectArrayList list3 = generator.m_226068_();
        list.addAll(list3);
        if (!list.isEmpty()) {
            int i = ((BlockPos)list.get(0)).m_123342_();
            list.stream().filter(pos -> pos.m_123342_() == i).forEach(pos -> this.setArea(generator, (BlockPos)pos));
        }
    }

    private void setArea(TreeDecorator.Context generator, BlockPos origin) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                if (Math.abs(i) == 2 || Math.abs(j) == 2) {
                    this.setColumn2(generator, origin.m_7918_(i, 0, j));
                    continue;
                }
                this.setColumn(generator, origin.m_7918_(i, 0, j));
            }
        }
    }

    private void setColumn(TreeDecorator.Context generator, BlockPos origin) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockPos = origin.m_6630_(i);
            if (Feature.m_65788_((LevelSimulatedReader)generator.m_226058_(), (BlockPos)blockPos)) {
                generator.m_226061_(blockPos, this.provider.m_213972_(generator.m_226067_(), origin));
                break;
            }
            if (!generator.m_226059_(blockPos) && i < 0) break;
        }
    }

    private void setColumn2(TreeDecorator.Context generator, BlockPos origin) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockPos = origin.m_6630_(i);
            if (Feature.m_65788_((LevelSimulatedReader)generator.m_226058_(), (BlockPos)blockPos)) {
                generator.m_226061_(blockPos, this.provider2.m_213972_(generator.m_226067_(), origin));
                if (!generator.m_226059_(blockPos.m_6630_(1)) || generator.m_226067_().m_188503_(50) != 0) break;
                generator.m_226061_(blockPos.m_6630_(1), ((Block)NSBlocks.SHIITAKE_MUSHROOM.get()).m_49966_());
                break;
            }
            if (!generator.m_226059_(blockPos) && i < 0) break;
        }
    }
}

