/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.foliage_placer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class RedwoodFoliagePlacer
extends FoliagePlacer {
    public static final Codec<RedwoodFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> RedwoodFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)instance).and((App)IntProvider.m_146545_((int)0, (int)32).fieldOf("trunk_height").forGetter(placer -> placer.trunkHeight)).apply((Applicative)instance, RedwoodFoliagePlacer::new));
    private final IntProvider trunkHeight;

    public RedwoodFoliagePlacer(IntProvider intProvider, IntProvider intProvider2, IntProvider trunkHeight) {
        super(intProvider, intProvider2);
        this.trunkHeight = trunkHeight;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)NSWorldGen.REDWOOD_FOLIAGE_PLACER_TYPE.get();
    }

    protected void m_213633_(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, int trunkHeight, FoliagePlacer.FoliageAttachment treeNode, int foliageHeight, int radius, int offset) {
        int a;
        BlockPos blockPos = treeNode.m_161451_();
        BlockPos.MutableBlockPos mutable = blockPos.m_122032_();
        int layers = random.m_216332_(1, 6);
        int middleLayers = layers / 2;
        int largeLayers = layers - middleLayers;
        mutable.m_122154_((Vec3i)blockPos, 0, ++offset, 0);
        this.m_225628_(world, placer, random, config, (BlockPos)mutable, 0, 0, treeNode.m_68590_());
        mutable.m_122154_((Vec3i)blockPos, 0, offset - 1, 0);
        this.m_225628_(world, placer, random, config, (BlockPos)mutable, 0, 0, treeNode.m_68590_());
        mutable.m_122154_((Vec3i)blockPos, 0, offset - 2, 0);
        this.m_225628_(world, placer, random, config, (BlockPos)mutable, 0, 0, treeNode.m_68590_());
        this.generateCross(world, placer, random, config, blockPos, 2, offset - 3, treeNode.m_68590_());
        this.generateCross(world, placer, random, config, blockPos, 1, offset - 4, treeNode.m_68590_());
        int middeY = offset - 5;
        for (a = middleLayers; a > 0; --a) {
            this.generateCircle(world, placer, random, config, blockPos, 2, middeY, treeNode.m_68590_());
            this.generateCross(world, placer, random, config, blockPos, 1, --middeY, treeNode.m_68590_());
            --middeY;
        }
        for (a = largeLayers; a > 0; --a) {
            this.generateBigCircularSquare(world, placer, random, config, blockPos, 3, middeY, treeNode.m_68590_());
            --middeY;
            if (a - 1 != 0) {
                this.generateCross(world, placer, random, config, blockPos, 2, middeY, treeNode.m_68590_());
            } else {
                this.generateCircularSquare(world, placer, random, config, blockPos, 3, middeY, treeNode.m_68590_());
                this.generateBigCircularSquare(world, placer, random, config, blockPos, 4, --middeY, treeNode.m_68590_());
                this.generateCross(world, placer, random, config, blockPos, 1, --middeY, treeNode.m_68590_());
                this.generateCircle(world, placer, random, config, blockPos, 2, --middeY, treeNode.m_68590_());
            }
            --middeY;
        }
    }

    protected void generateCircle(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, BlockPos centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.validateCircle(random, j, y, k, radius, giantTrunk)) continue;
                mutable.m_122154_((Vec3i)centerPos, j, y, k);
                RedwoodFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
            }
        }
    }

    protected void generateCross(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, BlockPos centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.validateCross(random, j, y, k, radius, giantTrunk)) continue;
                mutable.m_122154_((Vec3i)centerPos, j, y, k);
                RedwoodFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
            }
        }
    }

    protected void generateCircularSquare(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, BlockPos centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.validateCircularSquare(random, j, y, k, radius, giantTrunk)) continue;
                mutable.m_122154_((Vec3i)centerPos, j, y, k);
                RedwoodFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
            }
        }
    }

    protected void generateBigCircularSquare(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, BlockPos centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.validateBigCircularSquare(random, j, y, k, radius, giantTrunk)) continue;
                mutable.m_122154_((Vec3i)centerPos, j, y, k);
                RedwoodFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
            }
        }
    }

    public int m_214116_(RandomSource random, int trunkHeight, TreeConfiguration config) {
        return Math.max(8, trunkHeight - this.trunkHeight.m_214085_(random));
    }

    protected boolean m_214203_(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return false;
    }

    protected boolean validateCircle(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        if (giantTrunk) {
            dx = Math.min(Math.abs(dx), Math.abs(dx - 1));
            dz = Math.min(Math.abs(dz), Math.abs(dz - 1));
        } else {
            dx = Math.abs(dx);
            dz = Math.abs(dz);
        }
        return dx == radius && dz == radius && radius > 0;
    }

    protected boolean validateCircularSquare(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        if (giantTrunk) {
            dx = Math.min(Math.abs(dx), Math.abs(dx - 1));
            dz = Math.min(Math.abs(dz), Math.abs(dz - 1));
        } else {
            dx = Math.abs(dx);
            dz = Math.abs(dz);
        }
        return (dx == radius || dz == radius) && dx > 0 && dz > 0;
    }

    protected boolean validateBigCircularSquare(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        if (giantTrunk) {
            dx = Math.min(Math.abs(dx), Math.abs(dx - 1));
            dz = Math.min(Math.abs(dz), Math.abs(dz - 1));
        } else {
            dx = Math.abs(dx);
            dz = Math.abs(dz);
        }
        return (dx == radius || dz == radius) && dx > 1 && dz > 1;
    }

    protected boolean validateCross(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        if (giantTrunk) {
            dx = Math.min(Math.abs(dx), Math.abs(dx - 1));
            dz = Math.min(Math.abs(dz), Math.abs(dz - 1));
        } else {
            dx = Math.abs(dx);
            dz = Math.abs(dz);
        }
        return (dx > 0 || dz > 0) && dx != 0 && dz != 0;
    }
}

