/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.foliage_placer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Predicate;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class GroundedBushFoliagePlacer
extends FoliagePlacer {
    public static final Codec<GroundedBushFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> GroundedBushFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.m_146545_((int)1, (int)512).fieldOf("foliage_height").forGetter(placer -> placer.foliageHeight), (App)Codec.intRange((int)0, (int)256).fieldOf("leaf_placement_attempts").forGetter(placer -> placer.leafPlacementAttempts))).apply((Applicative)instance, GroundedBushFoliagePlacer::new));
    private final IntProvider foliageHeight;
    private final int leafPlacementAttempts;

    public GroundedBushFoliagePlacer(IntProvider radius, IntProvider offset, IntProvider foliageHeight, int leafPlacementAttempts) {
        super(radius, offset);
        this.foliageHeight = foliageHeight;
        this.leafPlacementAttempts = leafPlacementAttempts;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)NSWorldGen.GROUNDED_BUSH_PLACER_TYPE.get();
    }

    protected void m_213633_(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, int trunkHeight, FoliagePlacer.FoliageAttachment treeNode, int foliageHeight, int radius, int offset) {
        BlockPos blockPos = treeNode.m_161451_().m_7495_();
        BlockPos.MutableBlockPos mutable = blockPos.m_122032_();
        for (int i = 0; i <= foliageHeight; ++i) {
            for (int j = 0; j < this.leafPlacementAttempts / (i + 1); ++j) {
                mutable.m_122154_((Vec3i)blockPos, random.m_188503_(radius) - random.m_188503_(radius), i, random.m_188503_(radius) - random.m_188503_(radius));
                if (world.m_7433_(mutable.m_7495_(), Predicate.isEqual(Blocks.f_50016_.m_49966_()))) continue;
                GroundedBushFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
            }
        }
    }

    public int m_214116_(RandomSource random, int trunkHeight, TreeConfiguration config) {
        return this.foliageHeight.m_214085_(random);
    }

    protected boolean m_214203_(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return false;
    }
}

