/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.foliage_placer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class CypressFoliagePlacer
extends FoliagePlacer {
    public static final Codec<CypressFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> CypressFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)instance).and((App)IntProvider.m_146545_((int)0, (int)24).fieldOf("trunk_height").forGetter(placer -> placer.trunkHeight)).apply((Applicative)instance, CypressFoliagePlacer::new));
    private final IntProvider trunkHeight;

    public CypressFoliagePlacer(IntProvider intProvider, IntProvider intProvider2, IntProvider trunkHeight) {
        super(intProvider, intProvider2);
        this.trunkHeight = trunkHeight;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)NSWorldGen.CYPRESS_FOLIAGE_PLACER_TYPE.get();
    }

    protected void m_213633_(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, int trunkHeight, FoliagePlacer.FoliageAttachment treeNode, int foliageHeight, int radius, int offset) {
        BlockPos blockPos = treeNode.m_161451_();
        BlockPos.MutableBlockPos mutable = blockPos.m_122032_();
        boolean nextBoolean = random.m_188499_();
        boolean nextBoolean2 = random.m_188499_();
        boolean nextBoolean3 = random.m_188499_();
        int i = random.m_188503_(3);
        boolean j = true;
        boolean k = false;
        for (int l = offset; l >= -foliageHeight - 5; --l) {
            if (l <= offset - 4 && l >= offset - 14) {
                mutable.m_122154_((Vec3i)blockPos, 0, l, 0);
                this.m_225628_(world, placer, random, config, blockPos, 1, l, treeNode.m_68590_());
            }
            if (l >= offset - 5) {
                mutable.m_122154_((Vec3i)blockPos, 0, l, 0);
                if (nextBoolean && l == offset) {
                    CypressFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
                }
                if ((nextBoolean || nextBoolean2) && l == offset - 1) {
                    CypressFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
                }
                if ((nextBoolean || nextBoolean2 || nextBoolean3) && l == offset - 2) {
                    CypressFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
                }
                if (l > offset - 3) continue;
                CypressFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
                continue;
            }
            if (l == offset - 5) {
                mutable.m_122154_((Vec3i)blockPos, 0, l, 0);
                if (!random.m_188499_()) continue;
                CypressFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.m_5484_(Direction.m_235672_((RandomSource)random), 1).m_5484_(Direction.m_235672_((RandomSource)random), 1).m_6630_(1));
                continue;
            }
            if (l >= offset - 10) {
                mutable.m_122154_((Vec3i)blockPos, 0, l, 0);
                if (random.m_188499_()) {
                    CypressFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.m_5484_(Direction.NORTH, 1).m_5484_(Direction.EAST, 1));
                }
                if (random.m_188499_()) {
                    CypressFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.m_5484_(Direction.NORTH, 1).m_5484_(Direction.WEST, 1));
                }
                if (random.m_188499_()) {
                    CypressFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.m_5484_(Direction.SOUTH, 1).m_5484_(Direction.EAST, 1));
                }
                if (!random.m_188499_()) continue;
                CypressFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.m_5484_(Direction.SOUTH, 1).m_5484_(Direction.WEST, 1));
                continue;
            }
            if (l < offset - 13) continue;
            this.generateDiagonalSqaure(world, placer, random, config, blockPos, 2, l, treeNode.m_68590_());
        }
    }

    protected void m_225628_(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, BlockPos centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.m_214202_(random, j, y, k, radius, giantTrunk)) continue;
                mutable.m_122154_((Vec3i)centerPos, j, y, k);
                CypressFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
            }
        }
    }

    protected void generateDiagonalSqaure(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, BlockPos centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.isPositionInvalid2(random, j, y, k, radius, giantTrunk)) continue;
                mutable.m_122154_((Vec3i)centerPos, j, y, k);
                CypressFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
            }
        }
    }

    protected boolean isPositionInvalid2(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        int j;
        int i;
        if (giantTrunk) {
            i = Math.min(Math.abs(dx), Math.abs(dx - 1));
            j = Math.min(Math.abs(dz), Math.abs(dz - 1));
        } else {
            i = Math.abs(dx);
            j = Math.abs(dz);
        }
        return this.isInvalidForLeaves2(random, i, y, j, radius, giantTrunk);
    }

    public int m_214116_(RandomSource random, int trunkHeight, TreeConfiguration config) {
        return Math.max(8, trunkHeight - this.trunkHeight.m_214085_(random));
    }

    protected boolean m_214203_(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return dx == radius && dz == radius && radius > 0;
    }

    protected boolean isInvalidForLeaves2(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        int trunkHeight = this.trunkHeight.m_214085_(random);
        return (dx > 1 || dz > 1) && dx != 0 && dz != 0 && trunkHeight - y != trunkHeight;
    }
}

