/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.foliage_placer;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.hibiscus.naturespirit.registration.NSWorldGen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class BirchFoliagePlacer
extends FoliagePlacer {
    public static final Codec<BirchFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> BirchFoliagePlacer.createCodec(instance).apply((Applicative)instance, BirchFoliagePlacer::new));
    protected final int height;

    protected static <P extends BirchFoliagePlacer> Products.P3<RecordCodecBuilder.Mu<P>, IntProvider, IntProvider, Integer> createCodec(RecordCodecBuilder.Instance<P> builder) {
        return BirchFoliagePlacer.m_68573_(builder).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(placer -> placer.height));
    }

    public BirchFoliagePlacer(IntProvider radius, IntProvider offset, int height) {
        super(radius, offset);
        this.height = height;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)NSWorldGen.BIRCH_FOLIAGE_PLACER_TYPE.get();
    }

    protected void m_213633_(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, int trunkHeight, FoliagePlacer.FoliageAttachment treeNode, int foliageHeight, int radius, int offset) {
        for (int i = offset; i >= offset - foliageHeight; --i) {
            int j = Math.max(Math.min(radius + treeNode.m_68589_() - 1 - i / 2, 3), 0);
            if (i == offset - foliageHeight) {
                this.generateDiagonal(world, placer, random, config, treeNode.m_161451_(), radius, i, treeNode.m_68590_());
                continue;
            }
            if (j == 2 && Math.max(Math.min(radius + treeNode.m_68589_() - 2 - i / 2, 3), 0) == 1) {
                this.generateCircle(world, placer, random, config, treeNode.m_161451_(), j, i, treeNode.m_68590_());
                continue;
            }
            if (j == 3) {
                this.generateCircularSquare(world, placer, random, config, treeNode.m_161451_(), j, i, treeNode.m_68590_());
                continue;
            }
            this.m_225628_(world, placer, random, config, treeNode.m_161451_(), j, i, treeNode.m_68590_());
        }
    }

    protected void generateDiagonal(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, BlockPos centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.validateDiagonal(random, j, y, k, radius, giantTrunk)) continue;
                mutable.m_122154_((Vec3i)centerPos, j, y, k);
                BirchFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
            }
        }
    }

    protected void generateCircularSquare(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, BlockPos centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.validateCircularSquare(random, j, y, k, radius, giantTrunk)) continue;
                mutable.m_122154_((Vec3i)centerPos, j, y, k);
                BirchFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
            }
        }
    }

    protected void generateCircle(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, BlockPos centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.validateCircle(random, j, y, k, radius, giantTrunk)) continue;
                mutable.m_122154_((Vec3i)centerPos, j, y, k);
                BirchFoliagePlacer.m_272253_((LevelSimulatedReader)world, (FoliagePlacer.FoliageSetter)placer, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
            }
        }
    }

    protected boolean validateCircularSquare(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        dx = Math.abs(dx);
        dz = Math.abs(dz);
        return (dx == radius || dz == radius) && (dx != 0 && dz != 0 || random.m_188503_(3) == 0) || dx == radius - 1 && dz == radius - 1 && random.m_188503_(2) == 0;
    }

    protected boolean validateCircle(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        dx = Math.abs(dx);
        dz = Math.abs(dz);
        return dx == radius && dz == radius && radius > 0 && random.m_188501_() < 0.7f;
    }

    protected boolean validateDiagonal(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        dx = Math.abs(dx);
        dz = Math.abs(dz);
        return (dx > 1 || dz > 1) && dx != 0 && dz != 0;
    }

    public int m_214116_(RandomSource random, int trunkHeight, TreeConfiguration config) {
        return this.height;
    }

    protected boolean m_214203_(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return dx == radius && dz == radius && (random.m_188503_(2) == 0 || y == 0);
    }
}

